/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;

public class AccessTokenApi {
    private static final String FETCH_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";

    private AccessTokenApi() {
    }

    public static ApiResult get() {
        return AccessTokenApi.get(ParamManager.getAppid(), ParamManager.getSecret());
    }

    public static ApiResult get(String appId, String appSecret) {
        String url = String.format(FETCH_TOKEN, appId, appSecret);
        return ApiResult.build(HttpUtils.get(url));
    }

    public static String getString() {
        ApiResult res = AccessTokenApi.get();
        return AccessTokenApi.getAccessTokenFromApiResult(res);
    }

    public static String getString(String appId, String appSecret) {
        ApiResult res = AccessTokenApi.get(appId, appSecret);
        return AccessTokenApi.getAccessTokenFromApiResult(res);
    }

    private static String getAccessTokenFromApiResult(ApiResult res) {
        String token = null;
        if (res.isSuccess()) {
            token = String.valueOf(res.get("access_token"));
        }
        return token;
    }
}

