/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.MapUtils;
import java.util.Map;

public class MenuApi
extends BaseApi {
    private static final String MENU_CREATE_URL = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=";
    private static final String MENU_GET_URL = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=";
    private static final String MENU_DELETE_URL = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=";
    private static final String MENU_ADD_CONDITIONAL_URL = "https://api.weixin.qq.com/cgi-bin/menu/addconditional?access_token=";
    private static final String MENU_DELETE_CONDITION_URL = "https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token=";
    private static final String TRY_MATCH_URL = "https://api.weixin.qq.com/cgi-bin/menu/trymatch?access_token=";
    private static final String GET_CURRENT_SELF_MENUINFO_URL = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info?access_token=";

    private MenuApi() {
    }

    public static ApiResult create(String menus) {
        String url = MENU_CREATE_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, menus));
    }

    public static ApiResult get() {
        String url = MENU_GET_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }

    public static ApiResult delete() {
        String url = MENU_DELETE_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }

    public static ApiResult addConditionMenu(String menuJson) {
        String url = MENU_ADD_CONDITIONAL_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, menuJson));
    }

    public static ApiResult deleteConditionMenu(String menuId) {
        Map<String, String> params = MapUtils.of("menuid", menuId);
        String url = MENU_DELETE_CONDITION_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult tryMatch(String openid) {
        Map<String, String> params = MapUtils.of("user_id", openid);
        String url = TRY_MATCH_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult getCurrentSelfMenuInfo() {
        String url = GET_CURRENT_SELF_MENUINFO_URL + MenuApi.getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }
}

