/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class OAuthApi {
    private static final String OAUTH_URL = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=%s&redirect_uri=%s&response_type=code&scope=%s&state=%s#wechat_redirect";
    private static final String GET_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=%s&secret=%s&code=%s&grant_type=authorization_code";
    private static final String REFRESH_ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/refresh_token?appid=%s&grant_type=refresh_token&refresh_token=%s";
    private static final String GET_USER_INFO_URL = "https://api.weixin.qq.com/sns/userinfo?access_token=%s&openid=%s&lang=%s";
    private static final String DEFAULT_LANG = "zh_CN";
    private static final String DEFAULT_ENCODE_CHARACTER = "UTF-8";

    private OAuthApi() {
    }

    public static String buildUrl(String redirectUrl, String state, Type type) {
        return OAuthApi.buildUrl(ParamManager.getAppid(), redirectUrl, state, type);
    }

    public static String buildUrl(String appId, String redirectUrl, String state, Type type) {
        if (StringUtils.isBlank(redirectUrl) || type == null) {
            throw new IllegalArgumentException("url\u6216type\u4e3a\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return String.format(OAUTH_URL, appId, OAuthApi.URLEncode(redirectUrl), type.getValue(), state);
    }

    public static ApiResult getAccessToken(String code) {
        return OAuthApi.getAccessToken(code, ParamManager.getAppid(), ParamManager.getSecret());
    }

    public static ApiResult getAccessToken(String code, String appId, String appSecret) {
        if (StringUtils.isBlank(code)) {
            throw new NullPointerException("code is null");
        }
        String url = String.format(GET_ACCESS_TOKEN_URL, appId, appSecret, code);
        return ApiResult.build(HttpUtils.get(url));
    }

    public static String getOpenid(String code) {
        ApiResult res = OAuthApi.getAccessToken(code);
        return OAuthApi.getOpenIdFromApiResult(res);
    }

    public static String getOpenid(String code, String appId, String appSecret) {
        ApiResult res = OAuthApi.getAccessToken(code, appId, appSecret);
        return OAuthApi.getOpenIdFromApiResult(res);
    }

    private static String getOpenIdFromApiResult(ApiResult res) {
        if (res.isSuccess()) {
            return (String)res.fromJsonAsMap().get("openid");
        }
        return null;
    }

    public static ApiResult refreshAccessToken(String refreshToken) {
        return OAuthApi.refreshAccessToken(ParamManager.getAppid(), refreshToken);
    }

    public static ApiResult refreshAccessToken(String appId, String refreshToken) {
        if (StringUtils.isBlank(refreshToken)) {
            throw new NullPointerException("refresh token is null");
        }
        String url = String.format(REFRESH_ACCESS_TOKEN_URL, appId, refreshToken);
        return ApiResult.build(HttpUtils.get(url));
    }

    public static ApiResult getUserInfo(String accessToken, String openid, String lang) {
        if (StringUtils.isAnyBlank(accessToken, openid)) {
            throw new NullPointerException("access token or openid is null");
        }
        if (StringUtils.isBlank(lang)) {
            lang = DEFAULT_LANG;
        }
        String url = String.format(GET_USER_INFO_URL, accessToken, openid, lang);
        return ApiResult.build(HttpUtils.get(url));
    }

    private static String URLEncode(String s) {
        String res = null;
        try {
            res = URLEncoder.encode(s, DEFAULT_ENCODE_CHARACTER);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("url encoding failed!");
        }
        return res;
    }

    public static enum Type {
        BASE("snsapi_base"),
        INFO("snsapi_userinfo");

        private String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

