/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.ticket;

import com.rocoinfo.weixin.api.JssdkApi;
import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.ticket.DefaultTicketCache;
import com.rocoinfo.weixin.ticket.TicketCacheManager;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTicketManager
implements TicketCacheManager<DefaultTicketCache> {
    private static final String CACHE_KEY_PREV = "ticket_cache_key_";
    private final Map<String, DefaultTicketCache> ticketContainer = new ConcurrentHashMap<String, DefaultTicketCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultTicketCache getByAppIdSecret(String appId, String appSecret) {
        String cachedKey = CACHE_KEY_PREV + appId;
        DefaultTicketCache ticket = this.ticketContainer.get(cachedKey);
        if (this.expire(ticket)) {
            Class<DefaultTicketManager> clazz = DefaultTicketManager.class;
            synchronized (DefaultTicketManager.class) {
                String ticketString;
                ticket = this.ticketContainer.get(cachedKey);
                if (this.expire(ticket) && StringUtils.isNotBlank(ticketString = JssdkApi.getTicketStr(appId, appSecret))) {
                    ticket = new DefaultTicketCache(ticketString);
                    ticket.setCreateTime(System.currentTimeMillis());
                    this.ticketContainer.put(cachedKey, ticket);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return ticket;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return ticket;
            }
        }
        return ticket;
    }

    @Override
    public DefaultTicketCache get() {
        return this.getByAppIdSecret(ParamManager.getAppid(), ParamManager.getSecret());
    }

    private boolean expire(DefaultTicketCache ticket) {
        return ticket == null || ticket.getCreateTime() + ticket.getExpires() * 1000L <= System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.ticketContainer.clear();
    }
}

