/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.token;

import com.rocoinfo.weixin.api.AccessTokenApi;
import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.token.DefaultTokenCache;
import com.rocoinfo.weixin.token.TokenCacheManager;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTokenManager
implements TokenCacheManager<DefaultTokenCache> {
    private static final String CACHE_KEY_PREV = "token_cache_key_";
    private final Map<String, DefaultTokenCache> container = new ConcurrentHashMap<String, DefaultTokenCache>();

    private String getCacheKey(String appId) {
        return CACHE_KEY_PREV + appId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultTokenCache getByAppIdSecret(String appId, String appSecret) {
        String cachedKey = this.getCacheKey(appId);
        DefaultTokenCache token = this.container.get(cachedKey);
        if (this.expire(token)) {
            Class<DefaultTokenManager> clazz = DefaultTokenManager.class;
            synchronized (DefaultTokenManager.class) {
                String tokenString;
                token = this.container.get(cachedKey);
                if (this.expire(token) && StringUtils.isNotBlank(tokenString = AccessTokenApi.getString(appId, appSecret))) {
                    token = new DefaultTokenCache(tokenString);
                    token.setCreateTime(System.currentTimeMillis());
                    this.container.put(cachedKey, token);
                    // ** MonitorExit[var5_5] (shouldn't be in output)
                    return token;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return token;
            }
        }
        return token;
    }

    @Override
    public DefaultTokenCache get() {
        return this.getByAppIdSecret(ParamManager.getAppid(), ParamManager.getSecret());
    }

    @Override
    public DefaultTokenCache refresh() {
        this.container.remove(this.getCacheKey(ParamManager.getAppid()));
        return this.get();
    }

    @Override
    public DefaultTokenCache refreshByAppIdSecret(String appId, String appSecret) {
        this.container.remove(this.getCacheKey(appId));
        return this.getByAppIdSecret(appId, appSecret);
    }

    private boolean expire(DefaultTokenCache token) {
        return token == null || token.getCreateTime() + token.getExpires() * 1000L <= System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.container.clear();
    }
}

