/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.token;

import com.rocoinfo.weixin.token.DefaultTokenManager;
import com.rocoinfo.weixin.token.TokenCache;
import com.rocoinfo.weixin.token.TokenCacheManager;

public class TokenManager {
    private static TokenCacheManager cache;

    public static <T extends TokenCacheManager> void inject(T t) {
        if (t != null) {
            cache = t;
        }
    }

    public static String getAccessToken() {
        return ((TokenCache)cache.get()).getAccessToken();
    }

    public static String getAccessToken(String appId, String appSecret) {
        return ((TokenCache)cache.getByAppIdSecret(appId, appSecret)).getAccessToken();
    }

    public static String refreshAccessToken() {
        return ((TokenCache)cache.refresh()).getAccessToken();
    }

    public static String refreshAccessToken(String appId, String appSecret) {
        return ((TokenCache)cache.refreshByAppIdSecret(appId, appSecret)).getAccessToken();
    }

    public static void clear() {
        cache.clear();
    }

    static {
        if (cache == null) {
            cache = new DefaultTokenManager();
        }
    }
}

