package com.rocoinfo.rocomall.common;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.service.ServiceException;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;

import javax.servlet.http.HttpServletRequest;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/11 下午3:47</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
public abstract class BaseController {

	@InitBinder
	protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
		binder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat(Constants.YYYYMMDDHHMMSS), true));
		binder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat(Constants.YYYYMMDD), true));
		binder.registerCustomEditor(String.class, new StringEscapeEditor());
	}

	protected Logger logger = LoggerFactory.getLogger(getClass());

	@ExceptionHandler({QueryDataException.class})
	public Object queryDataException(Exception ex) {
		logger.error("数据查询异常:", ex);
		return StatusDto.buildDataFailureStatusDto(ex.getMessage());
	}

	@ExceptionHandler({ServiceException.class})
	public Object serviceException(Exception ex) {
		logger.error("service error", ex);
		return StatusDto.buildDataFailureStatusDto(ex.getMessage());
	}

	@ExceptionHandler({Exception.class})
	public Object exception(Exception ex) {
		logger.error("异常:", ex);
		return StatusDto.buildDataFailureStatusDto("操作失败");
	}
}
