package com.rocoinfo.rocomall.quartz;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.service.impl.product.ProductService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.List;
import java.util.Map;

/**
 * 被Spring的Quartz JobDetailBean定时执行的Job类, 支持持久化到数据库实现Quartz集群.
 * <p/>
 * 因为需要被持久化, 不能有用XXService等不能被持久化的成员变量, 只能在每次调度时从QuartzJobBean注入的applicationContext中动态取出.
 */
@SuppressWarnings("all")
public class ProductClusterableJob extends QuartzJobBean {

    private static Logger logger = LoggerFactory.getLogger(ProductClusterableJob.class);

    private ApplicationContext applicationContext;

    /**
     * 从SchedulerFactoryBean注入的applicationContext.
     */
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Override
    protected void executeInternal(JobExecutionContext ctx) throws JobExecutionException {
        ProductService productService = applicationContext.getBean(ProductService.class);
        Map config = (Map) applicationContext.getBean("timerJobConfig");
        String nodeName = (String) config.get("nodeName");

        List<Long> listIds = productService.scheduleList();
        List<Long> delistIds = productService.scheduleDelist();
        logger.info("上下架任务结束,上架{}个,下架{}个。", listIds.size(), delistIds.size());
        if (listIds.size() > 0 || delistIds.size() > 0) {
            List<Long> flushProdIds = Lists.newArrayList();
            flushProdIds.addAll(listIds);
            flushProdIds.addAll(delistIds);
        }
    }
}