package com.rocoinfo.rocomall.quartz;

import com.rocoinfo.rocomall.service.impl.UploadService;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.scheduling.quartz.QuartzJobBean;

import java.util.Map;

/**
 * 定期清理上传的临时文件. 被Spring的Quartz JobDetailBean定时执行的Job类, 支持持久化到数据库实现Quartz集群.
 * <p/>
 * 因为需要被持久化, 不能有用XXService等不能被持久化的成员变量,
 * 只能在每次调度时从QuartzJobBean注入的applicationContext中动态取出.
 */
@SuppressWarnings("all")
public class UploadCleanClusterableJob extends QuartzJobBean {

	private static Logger logger = LoggerFactory.getLogger(UploadCleanClusterableJob.class);

	private ApplicationContext applicationContext;

	/**
	 * 从SchedulerFactoryBean注入的applicationContext.
	 */
	public void setApplicationContext(ApplicationContext applicationContext) {
		this.applicationContext = applicationContext;
	}

	@Override
	protected void executeInternal(JobExecutionContext ctx) throws JobExecutionException {
		UploadService uploadService = applicationContext.getBean(UploadService.class);
		Map config = (Map) applicationContext.getBean("timerJobConfig");
		String nodeName = (String) config.get("nodeName");

		try {
			uploadService.scheduleCleanTmpFile();
			logger.info("清理上传的临时文件失败完成. nodeName={}", nodeName);
		} catch (Exception e) {
			logger.warn("清理上传的临时文件失败", e);
		}
	}
}