package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Address;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 收货地址接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/8/11 14:41</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/remote")
public class AddressRemoteRestController extends BaseController {

    @Autowired
    private IAddressService addressService;

    /**
     * 添加收获地址
     *
     * @param address 地址信息
     * @param userId  用户id
     * @return
     */
    @RequestMapping(value = "/addAddress", method = RequestMethod.POST)
    public Object add(Address address, Long userId) {
        if (userId == null)
            return StatusDto.buildFailureStatusDto("用户id不能为空");
        if (address == null)
            return StatusDto.buildFailureStatusDto("地址信息不能为空");
        address.setUser(new User(userId));
        address.setIsDefault(false);
        this.addressService.insert(address);
        return StatusDto.buildSuccessStatusDto("操作成功");
    }

    /**
     * 获取用户收货地址
     *
     * @param userId 用户id
     * @return
     */
    @RequestMapping(value = "/addresses")
    public Object get(Long userId) {
        if (userId == null)
            return StatusDto.buildFailureStatusDto("用户id不能为空");
        List<Address> list = this.addressService.findByUserId(userId);
        Object obj = ObjectFormatUtils.format2Map(list,
                "id->id", "userId->user.id", "consignee->consignee", "province->province", "address->address", "zipcode->zipcode", "mobile->mobile", "isDefault->isDefault");
        return StatusDto.buildDataSuccessStatusDto("操作成功", obj);
    }

    /**
     * 删除收获地址
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/delAddress")
    public Object delete(Long id) {
        if (id == null)
            return StatusDto.buildFailureStatusDto("id不能为空");
        this.addressService.deleteById(id);
        return StatusDto.buildSuccessStatusDto("删除成功");
    }

    /**
     * 设置默认地址
     *
     * @param userId 用户id
     * @param id     记录id
     * @return
     */
    @RequestMapping(value = "/defaultAddress")
    public Object setDefault(Long userId, Long id) {
        if (id == null)
            return StatusDto.buildFailureStatusDto("id不能为空");
        if (userId == null)
            return StatusDto.buildFailureStatusDto("用户id不能为空");
        boolean b = this.addressService.setDefault(userId, id);
        if (!b)
            return StatusDto.buildFailureStatusDto("设置失败");
        return StatusDto.buildSuccessStatusDto("设置成功");
    }
}
