package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Adv;
import com.rocoinfo.rocomall.enumconst.AdvType;
import com.rocoinfo.rocomall.service.impl.AdvService;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <dl>
 * <dd>Description: 广告设置接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/8/11 13:45</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/remote")
public class AdvRemoteRestController extends BaseController {

    @Autowired
    private AdvService advService;

    /**
     * 根据类型查询广告信息
     *
     * @param type 类型
     * @return
     */
    @RequestMapping(value = "/banners")
    public Object get(@RequestParam AdvType type) {
        if (type == null) {
            return StatusDto.buildFailureStatusDto("传入的类型为空");
        }
        List<Adv> list = this.advService.findByType(type, -1);
        Object obj = ObjectFormatUtils.format2Map(list,
                "id->id", "type->type", "title->title", "slogan->slogan", "imgUrl->imgUrl", "linkUrl->linkUrl");
        return StatusDto.buildDataSuccessStatusDto("操作成功", obj);
    }
}
