package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.enumconst.UserType;
import com.rocoinfo.rocomall.service.LoginService;
import com.rocoinfo.rocomall.service.LogoutService;
import com.rocoinfo.rocomall.service.impl.UserService;
import com.rocoinfo.rocomall.utils.ObjectFormatUtils;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <dl>
 * <dd>Description: 用户登录接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/8/11 17:35</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/remote")
public class LoginRemoteRestController extends BaseController {

    @Autowired
    private LoginService loginService;
    @Autowired
    private UserService userService;
    @Autowired
    private LogoutService logoutService;

    /**
     * 登录接口
     *
     * @param mobile   手机号(username)
     * @param password 密码
     * @return
     */
    @RequestMapping(value = "/login")
    public Object login(String mobile, String password) {
        if (StringUtils.isAnyBlank(mobile, password))
            return StatusDto.buildFailureStatusDto("用户名或者密码为空");
        StatusDto res = (StatusDto) this.loginService.login(mobile, password, false, UserType.MEMBER);

        if ("0".equals(res.getCode()))
            return res;
        // 登录成功,获取用户信息,返回到接口调用方,并且将用户在后台登出
        Long userId = WebUtils.getLoggedUserId();
        User user = this.userService.getById(userId);
        this.logoutService.logout();
        // format 返回的格式
        Object obj = ObjectFormatUtils.format2Map(user,
                "id->id", "name->name", "gender->gender", "idCard->idCard", "birthday->birthday", "mobile->mobilePhone", "imgUrl ->imgUrl");

        return StatusDto.buildDataSuccessStatusDto("登录成功", obj);
    }
}
