package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.params.OrderParams;
import com.rocoinfo.rocomall.service.order.INewOrderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * <dl>
 * <dd>Description:订单相关接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016年8月11日 下午5:01:00</dd>
 * <dd>@author：Kong</dd>
 * </dl>
 */
@RestController
@RequestMapping("/remote")
public class OrderRemoteRestController extends BaseController{

    @Autowired
    private INewOrderService newOrderService;

    /**
     * @param orderParams 订单参数实体对象
     * @return 订单id(orderId) 及订单子项id(orderItemId)
     */
    @RequestMapping(value = "/createOrder")
    public Object createOrder(OrderParams orderParams) {

        if (orderParams.getUserId() == null)
            return StatusDto.buildFailureStatusDto("用户id不能为空");

        if (orderParams.getSkuId() == null)
            return StatusDto.buildFailureStatusDto("购买商品skuId不能为空");

        if (orderParams.getQuantity() == null)
            return StatusDto.buildFailureStatusDto("购买商品数量不能为空");
        
        if(orderParams.getCost() == null){
        	orderParams.setCost(0.0);
        }
        //判断配送方式
        if (orderParams.getIsInvite() == null) {
            return StatusDto.buildFailureStatusDto("配送方式不能为空");
        } else if (orderParams.getIsInvite() == false) {
            if (orderParams.getAddressId() == null)
                return StatusDto.buildFailureStatusDto("用户收货地址Id不能为空");
        }

        return newOrderService.createOrder(orderParams);
    }

    /**
     * @param orderParams 订单参数实体对象
     * @return 0：失败 1：成功
     */
    @RequestMapping(value = "/payOrder")
    public Object payOrder(OrderParams orderParams) {

        if (orderParams.getOrderId() == null)
            return StatusDto.buildFailureStatusDto("支付订单id不能为空");
        
        if(orderParams.getPaymode() == null){
        	return StatusDto.buildFailureStatusDto("支付方式不能为空");
        }
        return newOrderService.payOrder(orderParams);
    }
    
    /**
     * 根据状态查询订单列表接口 
     * @param userId 用户Id
     * @param status 订单状态
     * @return
     * @throws Exception 
     */
    @RequestMapping("/orderList")
    public Object findOrderList(@RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "10") int length,
    		@RequestParam(defaultValue = "id") String orderColumn,@RequestParam(defaultValue = "DESC") String orderSort,Long userId, String status) throws Exception{
    	
    	if(userId == null){
    		throw new Exception();
//    		return StatusDto.buildDataFailureStatusDto("用户不能为空哦！");
    	}
    	PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		return newOrderService.findOrderItemList(pageable,userId, status);
    }
    
    /**
     * 查询订单详情
     * @param orderId 订单id
     * @return
     */
    @RequestMapping("/detailsOrder")
    public Object detailsOrder(Long orderId){
    	
    	return newOrderService.details(orderId);
    }
    
    /**
     * 用户取消订单
     * @param orderId 订单id
     * @param cancelReason
     * @return
     */
    @RequestMapping("/cancelOrder")
    public Object cancel(Long orderId, String cancelReason){
    	
    	return newOrderService.cancel(orderId, cancelReason);
    }
    
    /**
     * 用户删除支付完成的订单
     * @param orderId 订单id
     * @return
     */
    @RequestMapping("/deleteOrder")
    public Object delete(Long orderId){
    	
    	return newOrderService.delete(orderId);
    }
    
    /**
     * 用户提醒发货的接口
     * @param orderId 订单id
     * @return
     */
    @RequestMapping("/remindShipments")
    public Object remindShipments(Long orderId){
    	
    	return newOrderService.remindShipments(orderId);
    }
    
    /**
     * 确认收货接口
     * @param orderId 订单id
     * @return
     */
    @RequestMapping("/confirmDelivery")
    public Object confirmDelivery(Long orderId){
    	
    	return newOrderService.confirmDelivery(orderId);
    }
}

