package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.redis.CacheKeys;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.utils.RandomTools;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.shiro.session.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <dl>
 * <dd>Description: 短信相关接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/8/15 13:36</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/remote")
public class SmsRemoteRestController extends BaseController {

    @Autowired
    private JedisTemplate jedisTemplate;

    /**
     * 发送短信接口
     *
     * @param mobile 手机号码
     * @return
     */
    @RequestMapping(value = "/sms")
    public Object send(String mobile) {
        if (StringUtils.isBlank(mobile))
            return StatusDto.buildFailureStatusDto("手机号码不能为空");
        return this.sendSmsCode(mobile);
    }

    /**
     * 发送短信验证码(注册 找回密码等功能使用)
     *
     * @param mobilePhone 手机号
     * @return
     */
    private StatusDto sendSmsCode(String mobilePhone) {
        Session session = WebUtils.getSession();
        //Double check
        if (isAllowedSendSms(session, mobilePhone)) {
            synchronized (session) {
                if (isAllowedSendSms(session, mobilePhone)) {
                    // 发送短信时间
                    session.setAttribute(Constants.REGISTER_VCODE_SMS_TIMESTAMP, System.currentTimeMillis());
                    // 接收短信的手机号
                    session.setAttribute(Constants.REGISTER_VCODE_MOBILE_PHONE, mobilePhone);
                    // 生成随机验证码
                    String smsCode = RandomTools.getRandStr(4, 2);
                    // 验证码写死
                    smsCode = "1234";
                    logger.debug("发送验证码 {} 到 {}", smsCode, mobilePhone);
                    // TODO 短信内容待修改
                    String patten = "content";
                    String smsContent = String.format(patten, smsCode);
                    // TODO 发送接口滞后
                    //boolean success = this.sendSms(smsContent, mobilePhone);
                    boolean success = true;

                    session.setAttribute(Constants.REGISTER_VCODE, smsCode);
                    session.setAttribute(Constants.REGISTER_WRONGCOUNT, 0);

                    jedisTemplate.setex(CacheKeys.SMS_SEND_KEY_PREV + mobilePhone, smsCode, 60);

                    if (success) {
                        return StatusDto.buildSuccessStatusDto();
                    } else {
                        return StatusDto.buildFailureStatusDto("短信发送失败");
                    }
                } else {
                    return StatusDto.buildFailureStatusDto("您的操作过于频繁,请1分钟后再试!");
                }
            }
        } else {
            return StatusDto.buildFailureStatusDto("您的操作过于频繁,请1分钟后再试!");
        }
    }

    /**
     * 验证码：1分钟后可以重发验证码，验证码有效期：5分钟
     */
    private boolean isAllowedSendSms(Session session, String mobilePhone) {
        Long time = (Long) session.getAttribute(Constants.REGISTER_VCODE_SMS_TIMESTAMP);
        String smsCode = this.jedisTemplate.get(CacheKeys.SMS_SEND_KEY_PREV + mobilePhone);
        if (StringUtils.isNotBlank(smsCode)) {
            return false;
        }
        return time == null ||
                ((System.currentTimeMillis() - time) > DateUtils.MILLIS_PER_MINUTE * 1);
    }
}
