package com.rocoinfo.rocomall.remote;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.session.Session;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/8/15 16:40</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/remote")
public class ValidateCodeRestController extends BaseController {

    /**
     * 校验手机验证码
     *
     * @param mobile     接收验证码的手机号
     * @param verifyCode 验证码
     * @return
     */
    @RequestMapping(value = "/validateCode ")
    public Object validate(String mobile, String verifyCode) {
        if (StringUtils.isBlank(mobile))
            return StatusDto.buildFailureStatusDto("手机号不能为空");

        if (StringUtils.isBlank(verifyCode))
            return StatusDto.buildFailureStatusDto("验证码不能为空");

        Session session = WebUtils.getSession();
        String sessionMobilePhone = (String) session.getAttribute(Constants.REGISTER_VCODE_MOBILE_PHONE);

        if (sessionMobilePhone == null) {
            return StatusDto.buildFailureStatusDto("短信验证码不正确或已过期");
        }

        if (!sessionMobilePhone.equals(mobile)) {
            return StatusDto.buildFailureStatusDto("手机号必须是接收验证码的手机号");
        }

        if (!WebUtils.isSmsVCodeValid(verifyCode)) {
            return StatusDto.buildFailureStatusDto("短信验证码不正确或已过期");
        }

        return StatusDto.buildSuccessStatusDto("校验成功");
    }
}
