package com.rocoinfo.rocomall.rest;

import org.springframework.beans.propertyeditors.StringTrimmerEditor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.InitBinder;

import java.beans.PropertyEditorSupport;
import java.util.Date;

@ControllerAdvice
public class ControllerSetup {

	@InitBinder
	public void initBinder(WebDataBinder binder) {
		//trim 字符串参数
		binder.registerCustomEditor(String.class, new StringTrimmerEditor(false));

		//日期字符串 -> Date类型
		binder.registerCustomEditor(Date.class, new MillisecondDateEditor());
	}

	public static class MillisecondDateEditor extends PropertyEditorSupport {

		/**
		 * Parse the Date from the given text, using the specified DateFormat.
		 */
		@Override
		public void setAsText(String text) throws IllegalArgumentException {
			if (!StringUtils.hasText(text)) {
				// Treat empty String as null value.
				setValue(null);
			} else {
				setValue(new Date(Long.parseLong(text)));
			}
		}

		/**
		 * Format the Date as String, using the specified DateFormat.
		 */
		@Override
		public String getAsText() {
			Date value = (Date) getValue();
			return (value != null ? value.getTime() + "" : "");
		}

	}

}