package com.rocoinfo.rocomall.rest;

import com.fasterxml.jackson.databind.util.ClassUtil;
import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.MutipleDataStatusDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.service.IUploadService;
import com.rocoinfo.rocomall.service.impl.UploadService.UploadCategory;
import com.rocoinfo.rocomall.utils.ExcelUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;

/**
 * 
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-14 下午2:05:03</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/api/upload")
public class UploadRestController extends BaseController {

	@Autowired
	private IUploadService uploadService;

	@RequestMapping(method = RequestMethod.POST)
	public Object upload(HttpServletRequest req, HttpServletResponse response, MultipartFile file, @RequestParam UploadCategory type) {
		try {
			MutipleDataStatusDto dto = MutipleDataStatusDto.buildSuccessMutipleDataDto();
			String fileUrl = PropertyHolder.getImageBaseUrl() + uploadService.upload(file, type);
			String baseUrl = req.getRequestURL().toString();
			dto.setSomeData("fullPath", baseUrl.replace(req.getServletPath(), "") + fileUrl);
			dto.setSomeData("path", fileUrl);
			return dto;
		} catch (Exception e) {
			e.printStackTrace();
			return StatusDto.buildFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/validateExcel", method = RequestMethod.GET)
	public Object validateExcel(String path) {
		try {
			File file = uploadService.getFileByPath(path);
			if (!file.exists()) {
				return StatusDto.buildDataFailureStatusDto("文件不存在");
			}
			UploadCategory category = uploadService.parseCatalogType(path);
			if (!category.getPath().toLowerCase().endsWith("import")) {
				return StatusDto.buildDataFailureStatusDto("不是excel类型");
			}
			if (category.getClassName() == null) {
				return StatusDto.buildDataFailureStatusDto("后台类型数据配置不全");
			}
			ExcelUtil.getInstance().readExcel2ObjsByFile(file, ClassUtil.findClass(category.getClassName()));
			return StatusDto.buildDataSuccessStatusDto("文件验证成功");
		} catch (Exception e) {
			e.printStackTrace();
			return StatusDto.buildFailureStatusDto(e.getMessage());
		}
	}
}
