package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.Permission;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/12 上午9:58</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/adminUser")
public class AdminUserRestController extends BaseController {

	@Autowired
	private IAdminUserService adminUserService;

	@Autowired
	private ISupplierService supplierService;

	/**
	 * 分页查询管理员
	 * 
	 * @return
	 */
	@RequestMapping(method = RequestMethod.GET)
	public Object search(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
		@RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword, @RequestParam(required = false) SwitchStatus status) {

		keyword = StringUtils.trimToNull(keyword);
		PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));

		Map params = new HashMap<String, Object>();
		if (StringUtils.isNotEmpty(keyword)) {
			params.put("keywords", StringUtils.split(keyword, " "));
		}
		params.put("status", status);

		Page<AdminUser> page = adminUserService.searchScrollPage(params, pageRequest);

		List data = (List) ClassToMapUtil.dealSimple(page.getContent(), "id", "username", "name", "status");

		return new PageTable<AdminUser>(data, draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	/**
	 * 改变管理员状态
	 */
	@RequestMapping(value = "/{id}/switch", method = RequestMethod.GET)
	public Object switchStatus(@PathVariable Long id, @RequestParam SwitchStatus status) {
		adminUserService.switchAdminStatus(id, status);
		return StatusDto.buildDataSuccessStatusDto();
	}

	/**
	 * 新增或编辑管理员 ui
	 */
	@RequestMapping(value = "/{id}")
	public Object get(@PathVariable Long id) {
		final Map map = new HashMap(3);
		if (id > 0) {
			AdminUser admin = adminUserService.getById(id);
			if (admin != null) {
				adminUserService.buildAdminPermissionDetail(admin);
			}
			map.put("admin", admin);
			map.put("allPermissions", Permission.getGroupKeyValuePermissions());
		}
		map.put("roles", adminUserService.findAllRole());
		map.put("allSuppliers", supplierService.findSuppliers(Boolean.TRUE));

		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(map);
		return result;
	}

	@RequestMapping(value = "/create", method = RequestMethod.POST)
	public Object create(@Valid AdminUser adminUser) {
		adminUserService.saveAdminAndRole(adminUser);

		return StatusDto.buildDataSuccessStatusDto();

	}

	@RequestMapping(value = "/all")
	public Object findAll(@RequestParam(required = false) SwitchStatus status) {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		List data = (List) ClassToMapUtil.dealSimple(adminUserService.findAllWithStatus(status), "id", "name", "status");
		result.setData(data);
		return result;

	}

	@RequestMapping(value = "{id}/update", method = RequestMethod.POST)
	public Object update(@PathVariable Long id, AdminUser user) {
		if (!user.getId().equals(id)) {
			return StatusDto.buildFailureStatusDto("更新管理员用户Id参数不合法");
		}

		adminUserService.updateAdminAndRole(user);

		return StatusDto.buildDataSuccessStatusDto();

	}

}
