package com.rocoinfo.rocomall.rest.admin;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Adv;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.enumconst.AdvType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.impl.AdvService;
import com.rocoinfo.rocomall.utils.MapUtils;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: 广告管理</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2016/6/30 10:15</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@RestController
@RequestMapping(value = "/api/banners")
public class AdvRestController extends BaseController {

    @Autowired
    private AdvService advService;

    /**
     * 查询列表
     *
     * @param keyword 标题或者关键字
     * @param type    广告类型
     * @return
     */
    @RequestMapping
    private Object search(@RequestParam(required = false) String keyword,
                          @RequestParam(required = false) AdvType type,
                          @RequestParam(required = false) String draw,
                          @RequestParam(defaultValue = "0") int start,
                          @RequestParam(defaultValue = "20") int length,
                          @RequestParam(defaultValue = "id") String orderColumn,
                          @RequestParam(defaultValue = "DESC") String orderSort) {
        Map<String, Object> params = Maps.newHashMapWithExpectedSize(2);
        MapUtils.putNotNull(params, "keyword", keyword);
        MapUtils.putNotNull(params, "type", type);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
        Page<Adv> page = this.advService.searchScrollPage(params, pageable);
        return new PageTable<>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
    }

    /**
     * 保存广告
     *
     * @param adv 广告信息
     * @return
     */
    @RequestMapping(value = "/save")
    public Object save(Adv adv) {
        if (adv != null) {
            adv.setStatus(Status.LOCK);
            adv.setCreateTime(new Date());
            adv.setCreator(new AdminUser(WebUtils.getLoggedUserId()));
            this.advService.insert(adv);
        }
        return StatusDto.buildSuccessStatusDto("操作成功");
    }

    /**
     * 根据id查询
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/{id}/get")
    public Object get(@PathVariable Long id) {
        StatusDto res = StatusDto.buildSuccessStatusDto();
        if (id != null)
            res.setData(this.advService.getById(id));
        return res;
    }

    /**
     * 更新广告
     *
     * @param adv 广告信息
     * @return
     */
    @RequestMapping(value = "/update")
    public Object update(Adv adv) {
        if (adv != null) {
            this.advService.update(adv);
        }
        return StatusDto.buildSuccessStatusDto("更新成功!");
    }

    /**
     * 删除广告
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/{id}/delete")
    public Object delete(@PathVariable Long id) {
        if (id != null) {
            Adv adv = this.advService.getById(id);
            if (adv != null && Status.LOCK.equals(adv.getStatus()))
                this.advService.deleteById(id);
            else
                return StatusDto.buildFailureStatusDto("只有下线的广告才能被删除!");
        }
        return StatusDto.buildSuccessStatusDto("删除成功!");
    }
}
