package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: 选择商品模块</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/9/1  上午10:37</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/choosesku")
public class ChooseSkuRestController extends BaseController {
    @Autowired
    private ISkuService skuService;
    @Autowired
    private ICatalogService catalogService;


    @RequestMapping()
    public Object query(
            @RequestParam(required = false) String draw,@RequestParam(defaultValue = "0") int start,
            @RequestParam(defaultValue = "20") int length,@RequestParam(defaultValue = "id") String orderColumn,
            @RequestParam(defaultValue = "DESC") String orderSort,@RequestParam(required = false) String keyword,
            @RequestParam(required = false) Product.Status status) {

        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));

        Map<String, Object> params = new HashMap<String, Object>();

        if (StringUtils.isNotBlank(keyword)) {
            params.put("keywords", Arrays.asList(keyword.trim().replaceAll(" {2,}", " ").split(" ")));
        }

        params.put("status", status);

        List<Long> supplierIds = WebUtils.getWhereClauseSupplierIds(null);
        if (!CollectionUtils.isEmpty(supplierIds)){
            params.put("supplierIds",  supplierIds);
        }

        Page<Sku> page  = skuService.searchScrollPage(params, pageable);



        List   data  = (List)ClassToMapUtil.dealSimple(page.getContent(),
                "id","code","name","stock","status","cent","supplierName","product.listTime","product.delistTime","product.status");

        return new PageTable<Sku>(data,draw,Integer.valueOf(page.getTotalElements()+""));
    }

}
