package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.MyUploadService;
import com.rocoinfo.rocomall.dto.MutipleDataStatusDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.enumconst.UserType;
import com.rocoinfo.rocomall.service.LoginService;
import com.rocoinfo.rocomall.service.impl.AdminUserService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * <dl>
 * <dd>描述:登录 系统有多个登录界面: 包括前台、后台、微信网页、wap版、及将来可能会有的手机客户端版。</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年7月14日 下午3:02:47</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@Controller
@RequestMapping("/api/login")
@ResponseBody
public class LoginRestController {

    @Autowired
    private LoginService loginService;
    @Autowired
    private AdminUserService adminUserService;

    /**
     * @param username 用户名
     * @param password 秘密
     * @return
     */
    @RequestMapping(method = RequestMethod.POST)
    public Object login(@RequestParam String username,
                        @RequestParam String password) {

        if (StringUtils.isAnyBlank(username, password)) {
            return StatusDto.buildDataFailureStatusDto("账户或密码不正确");
        }

        StatusDto res = (StatusDto) loginService.login(username, password, false, UserType.ADMIN);
        if ("0".equals(res.getCode()))
            return res;

        MutipleDataStatusDto dto = MutipleDataStatusDto.buildSuccessMutipleDataDto();
        dto.setSomeData("user", this.adminUserService.getById(WebUtils.getLoggedUserId()));
        dto.setSomeData("imageTypeInfo", MyUploadService.ImageTypeInfo.convertToMap());
        return dto;
    }
}
