package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.PropertyHolder;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.utils.QRCodeUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springside.modules.web.Servlets;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * @author huyt
 */
@Controller
@RequestMapping(value = "/qrcode")
public class QRCodeRestController {

    @RequestMapping(value = "/file")
    @ResponseBody
    public Object generateQRCode(@RequestParam(required = true) String content) {
        if (StringUtils.isBlank(content)) {
            return StatusDto.buildFailureStatusDto("二维码内容为空！");
        }
        String imgPath = QRCodeUtils.generateQRCode(content).replaceAll("uploads/", PropertyHolder.getImageBaseUrl());
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData(imgPath);
        return result;
    }

    @RequestMapping(value = "/stream")
    public void generateQRCode(@RequestParam(required = true) String content, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("image/png");
        Servlets.setNoCacheHeader(response);
        try {
            QRCodeUtils.generateQRCode(content, response.getOutputStream());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
