package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProductSpecial;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.IProductSpecialService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;
import org.springside.modules.utils.Collections3;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author weiys
 */
@RestController
@RequestMapping("/api/rank")
@SuppressWarnings("all")
public class RankRestController extends BaseController {

	@Autowired
	private IProductSpecialService productSpecialService;

	@Autowired
	private ICatalogService catalogService;

	@RequestMapping(value = "", method = RequestMethod.GET)
	public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "display_order") String orderColumn,
		@RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword, @RequestParam(required = false) Integer typeId, @RequestParam(required = false) Status status) {

		Map<String, Object> params = new HashMap<String, Object>();
		if (typeId != null && typeId != 0) {
			params.put("typeId", typeId);
		}
		if (status != null) {
			params.put("status", status);
		}
		Page<ProductSpecial> pageResult = productSpecialService.searchScrollPage(params, new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn)));
		List data = (List) ClassToMapUtil.dealSimple(pageResult.getContent(), "id", "displayOrder", "type.id", "sku.name");
		return new PageTable<ProductSpecial>(data, draw, Integer.valueOf(pageResult.getTotalElements() + ""));
	}

	@RequestMapping(value = "/save", method = RequestMethod.POST)
	public Object setProduct(ProductSpecial productSpecial) {
		productSpecialService.insert(productSpecial);
		return StatusDto.buildSuccessStatusDto();
	}

	@RequestMapping(value = "/{id}/delete", method = RequestMethod.DELETE)
	public Object deleteSettingProduct(@PathVariable Long id) {
		ProductSpecial productSpecial = productSpecialService.getById(id);
		if (productSpecial != null) {
			productSpecialService.deleteById(id);
		}
		return StatusDto.buildDataSuccessStatusDto("删除成功!");
	}

	@RequestMapping(value = "/{id}")
	public Object getRank(@PathVariable Long id) {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(productSpecialService.getById(id));
		return result;
	}

	@RequestMapping(value = "/suppliers", method = RequestMethod.GET)
	public Object findUserSuppliers() {
		return WebUtils.getManagedSuppliersOfLoginUser();
	}

	@RequestMapping(value = "/catalogparents", method = RequestMethod.GET)
	public Object findCatalogParents() {
		return catalogService.findSubCatalogs(0);
	}

	/**
	 * 增加网站设置，判断类型和sku是否重复 返回1已存在 0 不存在
	 */
	@RequestMapping(value = "/checkExist", method = RequestMethod.GET)
	public Object checkExist(@RequestParam String productSpecialType, @RequestParam Long skuId) {
		StatusDto result = null;
		Map<String, Object> params = new HashMap<String, Object>();
		if (StringUtils.isNotEmpty(productSpecialType)) {
			params.put("type", productSpecialType);
		}
		if (null != skuId && skuId != 0) {
			params.put("skuId", skuId);
		}
		List<ProductSpecial> checkList = productSpecialService.findProdSepecialByParams(params);
		if (Collections3.isNotEmpty(checkList)) {
			result = StatusDto.buildSuccessStatusDto();
		} else {
			result = StatusDto.buildDataFailureStatusDto();
		}
		return result;
	}
}
