package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.common.QueryDataException;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.Permission;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.service.IAdminUserService;
import com.rocoinfo.rocomall.service.IRoleService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;
import org.springside.modules.utils.Collections3;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/role")
public class RoleRestController extends BaseController{

    @Autowired
    private IAdminUserService adminUserService;

    @Autowired
    private IRoleService roleService;

    /**
     * 查询角色列表
     * @param draw
     * @return
     */
    @RequestMapping()
    public Object showAllRoles(@RequestParam(required = true) String draw,@RequestParam(defaultValue = "id") String orderColumn,
                               @RequestParam(defaultValue = "DESC") String orderSort,@RequestParam(required = false) String keyword) throws QueryDataException{
        PageTable<Role> result = null;

        try {
            PageRequest pageable = new PageRequest(0, 1000, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
            Map<String,Object> params = params = new HashMap<String, Object>(4);;

            if(StringUtils.isNotEmpty(keyword)){
                params.put("name",keyword);
            }

            //查询角色
            Page<Role> page = roleService.searchScrollPage(params,pageable);
            List<Role> roles = page.getContent();

            if (Collections3.isNotEmpty(roles)){
                Map<String, Permission.Permissions> permissionsMap = Permission.convertAllPermissionsToMap();
                List<String> permissions = null;
                List<String> permissionLabels = null;

                //处理角色对应的权限
                for (Role role : roles){
                    adminUserService.buildRolePermissionDetail(role);//后期优化一次查出所以角色权限对应关系
                    permissions = role.getPermissions();

                    if (Collections3.isNotEmpty(permissions)){
                        permissionLabels = new ArrayList<String>(permissions.size());
                        for (String permission : permissions){
                            permissionLabels.add(permissionsMap.get(permission)==null?"":permissionsMap.get(permission).getLabel());
                        }
                    }
                    role.setPermissions(permissionLabels);
                }

                result = new PageTable<Role>(roles,draw,roles.size());
            }else{
                result = new PageTable<Role>(null,draw,0);
            }

            return result;
        } catch (Exception e) {
            throw new QueryDataException(e);
        }
    }

    /**
     * 新建角色
     * @param role
     */
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public Object create(Role role) {

        adminUserService.saveRoleAndPermissions(role);
        return StatusDto.buildDataSuccessStatusDto();
    }

    /**
     * 删除角色
     * @param id
     */
    @RequestMapping(value = "{id}/delete", method = RequestMethod.GET)
    public Object delete(@PathVariable Long id) {
        adminUserService.deleteRoleAndPermissionByRoleId(id);
        return StatusDto.buildDataSuccessStatusDto();
    }

    /**
     * 更新角色
     * @param id
     * @param role
     * @return
     */
    @RequestMapping(value = "{id}/update", method = RequestMethod.POST)
    public Object update(@PathVariable Long id, Role role) {
        role.setId(id);
        adminUserService.updateRoleAndPermissions(role);
        return StatusDto.buildDataSuccessStatusDto();
    }




    /**
     * 编辑时获取角色详情
     * @param id
     * @return
     */
    @RequestMapping(value = "/{id}/edit", method = RequestMethod.GET)
    public Object edit(@PathVariable Long id) {
        StatusDto<Map> edit = StatusDto.buildDataSuccessStatusDto();
        edit.setData(buildRoleInfoIntoModel(id));
        return edit;
    }

    /**
     * 获取所有权限
     * @param id
     * @return
     */
    @RequestMapping(value = "/getAllPermission", method = RequestMethod.GET)
    public Object getAllPermission() {
        StatusDto result = StatusDto.buildDataSuccessStatusDto();

        result.setData(Permission.getGroupKeyValuePermissions());

        return result;
    }

    private Map buildRoleInfoIntoModel(Long id){
        Map roleInfo = new HashMap(2);
        Role role = null;
        if (id > 0) {
            role = adminUserService.getRoleById(id);
            if (role!=null){
                adminUserService.buildRolePermissionDetail(role);
            }

            roleInfo.put("role", role);
            roleInfo.put("allPermissions", Permission.getHasPermissionGroupKeyValuePermissions(role.getPermissions()));

        }else{
            roleInfo.put("allPermissions", Permission.getGroupKeyValuePermissions());
        }

        return roleInfo;
    }

}

