package com.rocoinfo.rocomall.rest.admin;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.service.IAddressService;
import com.rocoinfo.rocomall.service.ILoginLogService;
import com.rocoinfo.rocomall.service.IUserService;
import com.rocoinfo.rocomall.service.cent.ICentConsumeRecordService;
import com.rocoinfo.rocomall.service.cent.ICentsService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:会员</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-9-14 下午2:04:10</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping(value = "/api/user")
public class UserRestController extends BaseController {

    @Autowired
    private IUserService userService;

    @Autowired
    private IAddressService addressService;

    @Autowired
    private ICentsService centsService;

    @Autowired
    private ICentConsumeRecordService centConsumeRecordService;

    @Autowired
    private ILoginLogService loginLogService;

    @RequestMapping(method = RequestMethod.GET)
    public Object search(@RequestParam(required = false) Date registStartDate, @RequestParam(required = false) Date registEndDate, @RequestParam(required = false) String keyword, @RequestParam(required = false) SwitchStatus status,
                         @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
                         @RequestParam(defaultValue = "DESC") String orderSort) {
        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(keyword)) {
            WebUtils.setObjectValue(params, "keyword", keyword);
        }
        WebUtils.setObjectValue(params, "status", status);
        WebUtils.setObjectValue(params, "registStartDate", registStartDate);
        WebUtils.setObjectValue(params, "registEndDate", registEndDate);
        PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
        Page<User> page = userService.searchScrollPage(params, pageable);
        return new PageTable<User>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
    }

    @RequestMapping(value = "{id}", method = RequestMethod.GET)
    public Object get(@PathVariable("id") Long id) {
        StatusDto dto = StatusDto.buildDataSuccessStatusDto();
        User user = userService.getById(id);
        if (user == null) {
            return StatusDto.buildDataFailureStatusDto("用户不存在");
        }
        dto.setData(user);
        return dto;
    }

    @RequestMapping(value = "/{id}/switch", method = RequestMethod.GET)
    @ResponseBody
    public Object switchStatus(@PathVariable Long id, @RequestParam SwitchStatus status) {
        User user = new User();
        user.setId(id);
        user.setStatus(status);
        userService.update(user);
        return StatusDto.buildSuccessStatusDto();
    }

    /**
     * 根据用户名查询用户信息
     */
    @RequestMapping(value = "/username/{username}", method = RequestMethod.GET)
    public Object getByUserName(@PathVariable String username) {
        StatusDto result = new StatusDto();
        User user = this.userService.getUserByUsername(username);
        if (user == null)
            return result.buildFailureStatusDto("用户不存在");
        result.setData(user);
        return result;
    }
}
