package com.rocoinfo.rocomall.rest.admin.cfg;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.cfg.Config;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.service.cfg.IConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

/**
 * <dl>
 * <dd>描述: 配置</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年12月15日 下午3:24:58</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@RestController
@RequestMapping("/api/config")
public class ConfigRestController extends BaseController {

	@Autowired
	private IConfigService configService;
	@Autowired
	private JedisTemplate jedisTemplate;

	@RequestMapping(value = "", method = RequestMethod.GET)
	public Object list() {
		return configService.findAll();
	}

	@RequestMapping(value = "", method = RequestMethod.POST)
	public Object updateConfig(HttpServletRequest request) {
		Enumeration<String> en = request.getParameterNames();

		List<String> keyList = new ArrayList<String>();
		List<Config> configList = Lists.newArrayList();
		while (en.hasMoreElements()) {
			String key = en.nextElement();
			String paramValue = request.getParameter(key);
			keyList.add(key);
			configList.add(new Config(key, paramValue));
		}

		this.configService.batchUpdate(configList);

		configService.clearServletCtxCachedConfig(keyList.toArray(new String[]{}));
		return StatusDto.buildSuccessStatusDto("配置更新成功");
	}
}