package com.rocoinfo.rocomall.rest.admin.cfg;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg;
import com.rocoinfo.rocomall.entity.cfg.SigninRuleCfg.CentCfgItem;
import com.rocoinfo.rocomall.service.cfg.ISigninRuleCfgService;
import com.rocoinfo.rocomall.utils.JsonUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>描述: 签到 送积分规则 配置</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年12月15日 下午3:24:58</dd>
 * <dd>创建人： 张敏</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/signRule")
public class SigninRuleCfgRestController extends BaseController {

	@Autowired
	private ISigninRuleCfgService signRuleService;

	@RequestMapping(value = "", method = RequestMethod.GET)
	public Object get() {
		return signRuleService.getUniqueSigninRule();
	}

	@RequestMapping(value = "", method = RequestMethod.POST)
	public Object createUpdateSignRule(SigninRuleCfg signRule) {
		Map<String, Object> params = new HashMap<String, Object>();

		String itemJson = StringUtils.EMPTY;
		if (CollectionUtils.isNotEmpty(signRule.getCfgItemList())) {
			//清除没用的数据
			CollectionUtils.filter(signRule.getCfgItemList(), new Predicate() {
				@Override
				public boolean evaluate(Object object) {
					CentCfgItem item = (CentCfgItem) object;
					return item != null && item.getDay() > 0;
				}
			});

			itemJson = JsonUtils.pojoNotEmptyToJson(signRule.getCfgItemList());
		}

		if (signRule.getId() == null) {
			signRule.setCode("0001");
			signRule.setName("签到规则");
		}

		signRule.setCentCfgJson(itemJson);

		if (signRule.getId() == null) {
			this.signRuleService.insert(signRule);
		} else {
			this.signRuleService.update(signRule);
		}
		return StatusDto.buildSuccessStatusDto("签到规则更新成功");
	}
}