package com.rocoinfo.rocomall.rest.admin.order;

import com.rocoinfo.rocomall.Constants;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.service.order.IOrderOutStoreService;
import com.rocoinfo.rocomall.utils.StringEscapeEditor;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:出库单管理</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：2015年11月16日 上午10:41:44</dd>
 * <dd>更新人： Johnny</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/orderOutStore")
public class OrderOutStoreRestController {
	@Autowired
	private IOrderOutStoreService orderOutStoreService;

	/**
	 * 显示出库单列表
	 * 
	 * @param keyword 仓库编码/仓库名称
	 * @param dateType 时间查询类型(今天：TODAY、昨天：YESTERDAY、近7日：NEARLY7DAYS)
	 * @param startDate 出库单起始时间(出库单创建时间)
	 * @param endDate 出库单结束时间(出库单创建时间)
	 * @param state 出库单状态（true|false）
	 * @return
	 * @throws ParseException
	 */
	@RequestMapping(method = RequestMethod.GET)
	public Object seach(@RequestParam(required = false) String draw, @RequestParam(required = false) DateType dateType, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length,
		@RequestParam(defaultValue = "id") String orderColumn, @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword, @RequestParam(required = false) Date startDate,
		@RequestParam(required = false) Date endDate, @RequestParam(required = false) Boolean state) throws ParseException {
		PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<OrderOutStore> page = null;
		page = this.orderOutStoreService.searchScrollPage(this.buildSearchParamMap(dateType, startDate, endDate, state, keyword), pageable);
		return new PageTable<OrderOutStore>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	private enum DateType {
		// 今天：TODAY、昨天：YESTERDAY、近7日：NEARLY7DAYS
		TODAY(0), YESTERDAY(-1), NEARLY7DAYS(7);
		private int day;

		DateType(int day) {
			this.day = day;
		}

		public int getDay() {
			return day;
		}
	}

	/**
	 * 构建差选条件的Map
	 * 
	 * @throws ParseException
	 */
	private Map<String, Object> buildSearchParamMap(final DateType dateType, final Date startDate, final Date endDate, final Boolean state, String keyword) {
		keyword = StringUtils.trimToNull(keyword);
		Map<String, Object> params = new HashMap<String, Object>();
		if (dateType == null) {
			if (startDate != null) {
				params.put("startDate", startDate);
			}

			if (endDate != null) {
				params.put("endDate", endDate);
			}
		} else {
			if (dateType == DateType.NEARLY7DAYS) {
				putDateParams(params, 0 - 24 * 60 * 60 * 1000 * 7l, 0l);
			} else if (dateType == DateType.TODAY) {
				putDateParams(params, 0, null);
			} else if (dateType == DateType.YESTERDAY) {
				putDateParams(params, 0 - 24 * 60 * 60 * 1000, null);
			} else {
				putDateParams(params, 0, null);
			}
		}
		if (state != null) {
			params.put("state", state);
		}
		if (keyword != null) {
			params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator(keyword, " ")));
		}
		return params;
	}

	/**
	 * @Title: putDateParams
	 * @Description: 获取时间
	 * @param 参数列表
	 * @return void
	 * @throws
	 */
	private static void putDateParams(Map<String, Object> params, long time, Long endTime) {
		Date date = new Date();
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd");// HH:mm:ss
		SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//
		Date currDate = new Date(date.getTime() + time);
		String currDateStr = sdf1.format(currDate);
		Date startDateTmp;
		Date endDateTmp = null;
		try {
			startDateTmp = sdf2.parse(currDateStr + " 00:00:00");
			params.put("startDate", startDateTmp);
		} catch (ParseException e) {
		}
		if (endTime == null) {
			try {
				endDateTmp = sdf2.parse(currDateStr + " 23:59:59");
			} catch (ParseException e) {
			}
		} else {
			Date endDate = new Date(date.getTime() + endTime.longValue());
			try {
				endDateTmp = sdf2.parse(sdf1.format(endDate) + " 23:59:59");
			} catch (ParseException e) {
			}
		}

		params.put("endDate", endDateTmp);
	}

	/**
	 * 修改出库单状态
	 */
	@RequestMapping(value = "/modifyState/{id}", method = RequestMethod.POST)
	public Object modifyExpress(Boolean state, @PathVariable Long id) throws Exception {
		try {
			if(id == null)
				return StatusDto.buildFailureStatusDto("出库单id不能为空!");
			OrderOutStore tempOrder = orderOutStoreService.getById(id);
			if(tempOrder == null)
				return StatusDto.buildFailureStatusDto("出库单id无效!");
			OrderOutStore orderOutStore = new OrderOutStore();
			orderOutStore.setId(id);
			orderOutStore.setSku(tempOrder.getSku());
			orderOutStore.setQuantity(tempOrder.getQuantity());
			orderOutStore.setState(state);
			orderOutStore.setOperateDatetime(new Date());
			orderOutStore.setOperator(new AdminUser(WebUtils.getLoggedUserId()));
			this.orderOutStoreService.execOutStore(orderOutStore);
			return StatusDto.buildSuccessStatusDto();
		} catch (Exception e) {
			return StatusDto.buildFailureStatusDto("保存失败!");
		}
	}

	@InitBinder
	protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
		binder.registerCustomEditor(Date.class, new CustomDateEditor(new SimpleDateFormat(Constants.YYYYMMDD), true));
		binder.registerCustomEditor(String.class, new StringEscapeEditor());
	}
}
