package com.rocoinfo.rocomall.rest.admin.product;

import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Brand;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.product.IBrandService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/brand")
public class BrandRestController extends BaseController {

	@Autowired
	private IBrandService brandService;

	@RequestMapping(method = RequestMethod.GET)
	public Object list(@RequestParam(required = false) String keyword, @RequestParam(required = false) Status status, @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start,
		@RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn, @RequestParam(defaultValue = "DESC") String orderSort) {
		Map<String, Object> params = Maps.newHashMapWithExpectedSize(2);
		if (StringUtils.isNotBlank(keyword)) {
			WebUtils.setObjectValue(params, "keywords", StringUtils.split(keyword, " "));
		}
		WebUtils.setObjectValue(params, "status", status);
		PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<Brand> page = brandService.searchScrollPage(params, pageable);
		return new PageTable<Brand>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/{id}")
	public Object get(@PathVariable Long id) {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(brandService.getById(id));
		return result;
	}

	@RequestMapping(value = "/all")
	public Object findAll() {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(brandService.findAll());
		return result;
	}

	@RequestMapping(value = "/create", method = RequestMethod.POST)
	public Object create(Brand brand) {
		brand.setStatus(Status.OPEN);
		brandService.insert(brand);
		return StatusDto.buildSuccessStatusDto("添加成功");
	}

	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public Object update(Brand brand) {
		brandService.update(brand);
		return StatusDto.buildSuccessStatusDto("更新成功");
	}
}
