package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.CatalogTreeDto;
import com.rocoinfo.rocomall.dto.CategoryTreeDto;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Catalog;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/catalog")
public class CatalogRestController extends BaseController {

    @Autowired
    private ICatalogService catalogService;

    @RequestMapping(value = "/all", method = RequestMethod.GET)
    public Object all() {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData(catalogService.findAll());
        return result;
    }

    @RequestMapping(value = "/save", method = RequestMethod.POST)
    public Object create(@Valid Catalog catalog) {
        catalogService.insert(catalog);
        StatusDto res = StatusDto.buildSuccessStatusDto();
        // 保存完后返回节点信息 以便前台处理节点
        int level = new Long(0).equals(catalog.getParentId()) ? CategoryTreeDto.LEVEL_1 : CategoryTreeDto.LEVEL_2;
        CategoryTreeDto dto = new CategoryTreeDto(catalog.getId(), catalog.getName(), level);
        res.setData(dto);
        return res;
    }

    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public Object update(@Valid Catalog catalog) {
        catalogService.update(catalog);
        StatusDto res = StatusDto.buildSuccessStatusDto();
        // 保存完后返回节点信息 以便前台处理节点
        int level = new Long(0).equals(catalog.getParentId()) ? CategoryTreeDto.LEVEL_1 : CategoryTreeDto.LEVEL_2;
        CategoryTreeDto dto = new CategoryTreeDto(catalog.getId(), catalog.getName(), level);
        res.setData(dto);
        return res;
    }

    /**
     * 根据id获取分类信息
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/{id}/get")
    public Object get(@PathVariable Long id) {
        StatusDto res = StatusDto.buildSuccessStatusDto();
        res.setData(this.catalogService.getById(id));
        return res;
    }

    @RequestMapping(value = "/{catalogId}/getInfo", method = RequestMethod.GET)
    public Object getCatalog(@PathVariable Long catalogId) {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        if (catalogId > 0) {
            Catalog catalog = catalogService.getById(catalogId);
            if (catalog != null) {
                result.setData(ClassToMapUtil.dealSimple(catalog, "id", "name", "code", "status", "displayOrder", "parentId", "fullImgUrl"));
            }
        }
        return result;
    }

    /**
     * 根据id删除
     *
     * @param id id
     * @return
     */
    @RequestMapping(value = "/{id}/delete")
    public Object delete(@PathVariable Long id) {
        if (id != null)
            this.catalogService.deleteById(id);
        return StatusDto.buildSuccessStatusDto("删除成功");
    }

    // 分类管理列表
    @RequestMapping(value = "/tree")
    public Object tree() {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        CatalogTreeDto rootNode = new CatalogTreeDto();
        rootNode.setId(0l);
        CatalogTreeDto treeDto = CatalogTreeDto.constructTree(rootNode, catalogService.findAll(), 1);
        result.setData(treeDto.getChildren());
        return result;
    }
}
