package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.ProdComment;
import com.rocoinfo.rocomall.entity.ProdComment.Show;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.entity.order.OrderItem;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.product.IProdCommentService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/prodcomment")
public class ProdCommentRestControaller extends BaseController {

    @Autowired
    private IProdCommentService prodCommentService;
    @Autowired
    private IOrderItemService orderItemService;

    @RequestMapping()
    public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "1") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
                       @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank(keyword)) {
            params.put("keyword", keyword.trim());
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
        Page<ProdComment> page = prodCommentService.searchScrollPage(params, pageRequest);
        return new PageTable<ProdComment>(page.getContent(), draw, page.getContent().size());
    }

    /**
     * 新增评论
     *
     * @param prodComment
     */
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    public Object create(@RequestParam(required = true) Long orderItemId, @RequestParam(required = true) String content, @RequestParam(required = false) String picturePath, @RequestParam(required = true) String level) {
        if (content.trim().equals("")) {
            return StatusDto.buildDataFailureStatusDto("评论内容不能为空！");
        }
        OrderItem item = orderItemService.getById(orderItemId);
        if (item == null) {
            return StatusDto.buildDataFailureStatusDto("没有此订单信息！");
        }
        Long userid = WebUtils.getLoggedUserId();
        if (!item.getUser().getId().equals(userid)) {
            return StatusDto.buildDataFailureStatusDto("您没有评论此订单商品的权限！");
        }

        User user = new User();
        user.setId(userid);

        ProdComment com = new ProdComment();
        com.setContent(content);
        com.setCreateTime(new Date());
        com.setLevel(level);
        com.setOrderItem(item);
        com.setPicturePath(picturePath);
        com.setShow(Show.DISPLAY);
        com.setUser(user);
        try {
            prodCommentService.insert(com);
            return StatusDto.buildSuccessStatusDto("评论添加成功！");
        } catch (Exception e) {
            return StatusDto.buildDataFailureStatusDto("评论添加失败！");
        }
    }

    /**
     * 更新评论
     *
     * @param prodComment
     */
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public Object update(ProdComment prodComment) {
        try {
            prodCommentService.update(prodComment);
            return StatusDto.buildSuccessStatusDto("修改成功！");
        } catch (Exception e) {
            logger.error("SupplierRestController create error.{}", e);
            return StatusDto.buildDataFailureStatusDto("修改失败！");
        }
    }

}