package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.PriceHistory;
import com.rocoinfo.rocomall.entity.ProdTemp;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.account.AdminLog;
import com.rocoinfo.rocomall.entity.order.InstoreOrder;
import com.rocoinfo.rocomall.entity.order.OrderOutStore;
import com.rocoinfo.rocomall.service.impl.AdminLogService;
import com.rocoinfo.rocomall.service.order.IInstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderOutStoreService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.IPriceHistoryService;
import com.rocoinfo.rocomall.service.product.IProductService;
import com.rocoinfo.rocomall.utils.JsonUtils;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-17 上午9:56:04</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/product")
public class ProductRestController extends BaseController {
	@Autowired
	private IProductService productService;
	@Autowired
	private ICatalogService catalogService;
	@Autowired
	private AdminLogService adminLogService;

	@Autowired
	private IPriceHistoryService priceHistoryService;

	@Autowired
	private IInstoreOrderService instoreService;

	@Autowired
	private IOrderOutStoreService outstoreService;

	// 获取商品详情
	@RequestMapping(value = "{id}/detail", method = RequestMethod.GET)
	public Object getJson(@PathVariable long id) {
		Product product = productService.getById(id);
		productService.buildDetail(product);
		StatusDto<Product> statusDto = StatusDto.buildDataSuccessStatusDto();
		statusDto.setData(product);
		return statusDto;
	}

	// 添加商品
	@RequestMapping(value = "create", method = RequestMethod.POST)
	public Object create(String productJson) {
		Product product = convertJsonToObject(productJson);
		if (product == null) {
			return StatusDto.buildDataFailureStatusDto("请检查json格式是否正确!");
		}
		product.setStatus(Product.Status.DRAFT);// 新的默认为草稿
		productService.create(product, WebUtils.getLoggedUserId());
		return StatusDto.buildDataSuccessStatusDto();
	}

	// 添加临时商品
	@RequestMapping(value = "create/temp", method = RequestMethod.POST)
	public Object createTemp(String productJson) {
		if (StringUtils.isBlank(productJson)) {
			return StatusDto.buildDataFailureStatusDto("json串不能为空");
		}
		productJson = replaceUnnecessary(productJson);
		StatusDto<Long> dto = StatusDto.buildDataSuccessStatusDto();
		Long id = productService.createTemp(productJson, WebUtils.getLoggedUserId());
		dto.setData(id);
		return dto;
	}

	/**
	 * 获取临时商品json 串
	 * 
	 */
	@RequestMapping(value = "get/temp", method = RequestMethod.GET)
	public Object getTempProd(Product product) {
		StatusDto<String> dto = StatusDto.buildDataSuccessStatusDto();
		product.setStatus(Product.Status.DRAFT);
		ProdTemp temp = productService.getLastProdTempByUserId(WebUtils.getLoggedUserId());
		if (temp != null) {
			dto.setData(temp.getJsonString());
		}
		return dto;
	}

	// 修改商品
	@RequestMapping(value = "{id}/update", method = RequestMethod.POST)
	public Object update(@PathVariable long id, String productJson) {
		Product product = convertJsonToObject(productJson);
		if (product == null) {
			return StatusDto.buildDataFailureStatusDto("请检查json格式是否正确!");
		}
		product.setId(id);
		productService.update(product, WebUtils.getLoggedUserId());
		return StatusDto.buildSuccessStatusDto();
	}

	// 修改临时商品
	@RequestMapping(value = "{id}/update/temp", method = RequestMethod.POST)
	public Object updateTemp(@PathVariable long id, String productJson) {
		if (StringUtils.isBlank(productJson)) {
			return StatusDto.buildDataFailureStatusDto("json串不能为空");
		}
		productJson = replaceUnnecessary(productJson);
		productService.updateTemp(productJson, id);
		return StatusDto.buildSuccessStatusDto();
	}

	private Product convertJsonToObject(String jsonStr) {
		try {
			if (StringUtils.isBlank(jsonStr)) {
				return null;
			}
			jsonStr = replaceUnnecessary(jsonStr);
			logger.info(jsonStr);
			return JsonUtils.fromJson(jsonStr, Product.class);
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}

	private String replaceUnnecessary(String jsonStr) {
		if (StringUtils.isBlank(jsonStr)) {
			return null;
		}
		return jsonStr.replaceAll("&quot;", "\"");
	}

	/**
	 * 弃用
	 */
	@RequestMapping(value = "{id}/discard", method = RequestMethod.POST)
	public Object discard(@PathVariable long id) {
		productService.discard(id, WebUtils.getLoggedUserId());
		return StatusDto.buildDataSuccessStatusDto();

	}

	/**
	 * 提交审核
	 */
	@RequestMapping(value = "{id}/submit-audit", method = RequestMethod.POST)
	public Object submitAudit(@PathVariable Long id) {
		productService.submitAudit(id, WebUtils.getLoggedUserId());
		return StatusDto.buildDataSuccessStatusDto();
	}

	/**
	 * 审核拒绝
	 */
	@RequestMapping(value = "{id}/audit-refuse", method = RequestMethod.POST)
	public Object auditRefuse(@PathVariable Long id) {
		productService.auditRefuse(id, WebUtils.getLoggedUserId());
		return StatusDto.buildDataSuccessStatusDto();
	}

	/**
	 * 审核通过
	 */
	@RequestMapping(value = "{id}/audit-ok", method = RequestMethod.POST)
	public Object auditOk(@PathVariable Long id) {
		productService.auditOk(id, WebUtils.getLoggedUserId());
		return StatusDto.buildDataSuccessStatusDto();
	}

	/**
	 * 下架
	 */
	@RequestMapping(value = "{id}/de-list", method = RequestMethod.POST)
	public Object deList(@PathVariable Long id) {
		productService.delist(id, WebUtils.getLoggedUserId());
		return StatusDto.buildDataSuccessStatusDto();
	}

	/**
	 * 上架
	 */
	@RequestMapping(value = "{id}/list", method = RequestMethod.POST)
	public Object list(@PathVariable Long id) {
		try {
			productService.list(id, WebUtils.getLoggedUserId());
		} catch (Exception e) {
			logger.error(e.getMessage());
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
		return StatusDto.buildDataSuccessStatusDto();
	}

	// 商品价格历史
	@RequestMapping(value = "{skuId}/price-history", method = RequestMethod.GET)
	public Object priceHistory(@PathVariable long skuId, @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length,
		@RequestParam(defaultValue = "time") String orderColumn, @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

		// FIXME TODO modify 要修改成 {skuId}要改成 productId,按照productId查询

		Map<String, Object> params = new HashMap<String, Object>();
		params.put("skuId", skuId);

		PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<PriceHistory> page = priceHistoryService.searchScrollPage(params, pageable);
		return new PageTable<PriceHistory>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	// 操作记录
	@RequestMapping(value = "{productId}/admin-log", method = RequestMethod.GET)
	public Object adminLog(@PathVariable long productId, @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length,
		@RequestParam(defaultValue = "action_time") String orderColumn, @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

		Map<String, Object> params = new HashMap<String, Object>();
		params.put("objectType", AdminLog.ObjectType.PRODUCT);
		params.put("objectId", productId);

		PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<AdminLog> page = adminLogService.search(params, pageable);
		return new PageTable<AdminLog>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	// 入库记录
	@RequestMapping(value = "{productId}/instoreRecord")
	public Object instoreRecords(@PathVariable Long productId, @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length) {
		PageRequest pageable = new PageRequest(start, length);
		Page<InstoreOrder> page = instoreService.searchInstoreRecordsByProdId(productId, pageable);
		return new PageTable<InstoreOrder>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	// 出库记录
	@RequestMapping(value = "{productId}/outstoreRecord")
	public Object outstoreRecords(@PathVariable Long productId, @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length) {
		PageRequest pageable = new PageRequest(start, length);
		Page<OrderOutStore> page = outstoreService.searchOutstoreRecordsByProdId(productId, pageable);
		return new PageTable<OrderOutStore>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
	}
}
