package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Product;
import com.rocoinfo.rocomall.entity.Sku;
import com.rocoinfo.rocomall.entity.Sku.StockStatus;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import com.rocoinfo.rocomall.service.order.IInstoreOrderService;
import com.rocoinfo.rocomall.service.order.IOrderItemService;
import com.rocoinfo.rocomall.service.product.ICatalogService;
import com.rocoinfo.rocomall.service.product.ISkuService;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.CodeGenerator;
import com.rocoinfo.rocomall.utils.CustomFunctions;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:sku controller</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>@创建时间：2015-8-17 上午10:40:34</dd>
 * <dd>@author： 张文山</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping(value = "/api/sku")
public class SkuRestController extends BaseController {

	protected Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private ISkuService skuService;
	@Autowired
	private ICatalogService catalogService;
	@Autowired
	private ISupplierService supplierService;
	@Autowired
	private IInstoreOrderService instoreOrderService;
	@Autowired
	private CodeGenerator codeGenerator;
	@Autowired
	private IDictWarehouseService dictWarehouseService;
	@Autowired
	private IOrderItemService orderItemService;

	/**
	 * 商品管理
	 */
	@RequestMapping()
	public Object managerSku(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
		@RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword, @RequestParam(required = false) String source, @RequestParam(required = false) Product.Status status,
		@RequestParam(required = false) StockStatus stockStatus, @RequestParam(required = false) Boolean isOnSale, @RequestParam(required = false) Long catalogId, @RequestParam(required = false) Long supplierId,
		@RequestParam(required = false) Long brandId, @RequestParam(required = false) Boolean isVisual, @RequestParam(required = false) Boolean supportDiscount, @RequestParam(required = false) List<Long> excludeSkuIds) {

		PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));

		Map<String, Object> params = new HashMap<String, Object>();

		if (StringUtils.isNotBlank(keyword)) {
			params.put("keywords", StringUtils.split(keyword, " "));
		}

		if (catalogId != null) {
			params.put("catalogIds", catalogService.findSubTreeIds(catalogId));
		}

		if (StringUtils.isNotBlank(source) && source.equals("skuStore")) {
			if (StringUtils.isNotBlank(keyword)) {
				params.put("sourceCatalogIds", catalogService.findCatalogIdsbyName(keyword));
			}
		}

		if (!CollectionUtils.isEmpty(excludeSkuIds)) {
			params.put("excludeSkuIds", excludeSkuIds);
		}

		params.put("status", status);
		params.put("stockStatus", stockStatus);
		params.put("isVisual", isVisual);

		params.put("brandId", brandId);

		Page<Sku> page = skuService.searchScrollPage(params, pageable);

		List<Sku> skuList = page.getContent();// 提高循环效率
		for (Sku sku : skuList) {
			if (sku.getProduct().getStatus() != null) {
				sku.setCanDos(CustomFunctions.canDoMap.get(sku.getProduct().getStatus().name()));
			}
		}

		return new PageTable<Sku>(skuList, draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	/**
	 * Id 查询商品详情
	 *
	 * @param sukId
	 * @return
	 */
	@RequestMapping(value = "/{sukId}", method = RequestMethod.GET)
	public Object getSuk(@PathVariable Long sukId) {
		if (sukId == null)
			return StatusDto.buildFailureStatusDto();
		StatusDto sd = StatusDto.buildSuccessStatusDto();

		Sku sku = skuService.getById(sukId);
		skuService.buildDetail(sku);

		sd.setData(sku);
		return sd;
	}

	/**
	 * Id 查询商品详情
	 *
	 * @param sukId
	 * @return
	 */
	@RequestMapping(value = "/code/{code}", method = RequestMethod.GET)
	public Object getSkuByCode(@PathVariable String code) {
		if (StringUtils.isBlank(code))
			return StatusDto.buildFailureStatusDto();
		StatusDto sd = StatusDto.buildSuccessStatusDto();

		Sku sku = skuService.getByCode(code);
		skuService.buildDetail(sku);

		sd.setData(sku);
		return sd;
	}

	/**
	 * 更新SKU
	 * 
	 * @param sku
	 */
	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public Object update(Sku sku) {
		try {
			skuService.update(sku);
			return StatusDto.buildSuccessStatusDto("修改成功");
		} catch (Exception e) {
			logger.error("SupplierRestController create error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

}