package com.rocoinfo.rocomall.rest.admin.product;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.Supplier;
import com.rocoinfo.rocomall.service.product.ISupplierService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/supplier")
public class SupplierRestController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(SupplierRestController.class);
	@Autowired
	private ISupplierService supplierService;

	@RequestMapping(method = RequestMethod.GET)
	public Object list(@RequestParam(required = false) String keyword, @RequestParam(required = false) String draw,
			@RequestParam(required = false) Boolean useable, @RequestParam(defaultValue = "0") int start,
			@RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
			@RequestParam(defaultValue = "DESC") String orderSort) {
		Map<String, Object> params = new HashMap<String, Object>();
		if(StringUtils.isNotBlank(keyword)){
			params.put("keyword", StringUtils.splitByWholeSeparator(keyword.trim(), " "));
		}
		WebUtils.setObjectValue(params, "useable", useable);
		PageRequest pageable = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<Supplier> page = supplierService.searchScrollPage(params, pageable);
		return new PageTable<Supplier>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/{id}/getInfo")
	public Object get(@PathVariable Long id) {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(supplierService.getById(id));
		return result;
	}

	@RequestMapping(value = "/create")
	public Object create(Supplier supplier) {
		try {
			supplierService.insert(supplier);
			return StatusDto.buildSuccessStatusDto("添加成功");
		} catch (Exception e) {
			logger.error("SupplierRestController create error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/update")
	public Object update(Supplier supplier) {
		try {
			supplierService.update(supplier);
			return StatusDto.buildSuccessStatusDto("更新成功");
		} catch (Exception e) {
			logger.error("SupplierRestController update error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	// 登录者拥有的供应商
	@RequestMapping(value = "/loginedSuppliers")
	public Object getLoginedSuppliers() {
		try {
			StatusDto result = StatusDto.buildSuccessStatusDto();
			result.setData(supplierService.findUseableSupplysByAdminId(WebUtils.getLoggedUserId()));
			return result;
		} catch (Exception e) {
			logger.error("SupplierRestController update error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}
}
