package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictCentAttribution;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.dict.IDictCentAttributionService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 积分归属
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/centconsume/owner")
public class DictCentAttributionRestController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(DictCentAttributionRestController.class);

	@Autowired
	private IDictCentAttributionService dictAttributionService;

	@RequestMapping()
	public Object list(@RequestParam(required = false) Status status, @RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length,
		@RequestParam(defaultValue = "id") String orderColumn, @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

		Map<String, Object> params = new HashMap<String, Object>();
		if (StringUtils.isNotBlank(keyword)) {
			WebUtils.setObjectValue(params, "keywords", StringUtils.split(keyword, " "));
		}
		PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<DictCentAttribution> page = dictAttributionService.searchScrollPage(params, pageRequest);

		return new PageTable<DictCentAttribution>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/{id}/getInfo")
	public Object get(@PathVariable Long id) {
		DictCentAttribution dictCentConsumeOwner = dictAttributionService.getById(id);
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(dictCentConsumeOwner);
		return result;
	}

	@RequestMapping(value = "/create", method = RequestMethod.POST)
	public Object create(DictCentAttribution centConsumeOwner) {
		try {
			dictAttributionService.insert(centConsumeOwner);
			return StatusDto.buildSuccessStatusDto("类型添加成功");
		} catch (Exception e) {
			logger.error("DictCentConsumeTypeRestController create error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public Object update(DictCentAttribution centConsumeOwner) {
		try {
			dictAttributionService.update(centConsumeOwner);
			return StatusDto.buildSuccessStatusDto("类型修改成功");
		} catch (Exception e) {
			logger.error("DictCentConsumeTypeRestController update error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/getAll")
	public Object getAll() {
		StatusDto result = StatusDto.buildSuccessStatusDto();
		result.setData(dictAttributionService.findAll());
		return result;
	}
}
