package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictCentConsumeType;
import com.rocoinfo.rocomall.service.dict.IDictCentConsumeTypeService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * 积分消耗类型管理
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/centconsume")
public class DictCentConsumeTypeRestController extends BaseController {

    private final Logger logger = LoggerFactory.getLogger(DictCentConsumeTypeRestController.class);

    @Autowired
    private IDictCentConsumeTypeService dictConsumeTypeService;

    @RequestMapping()
    public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start,
                       @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
                       @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNoneBlank(keyword)) {
            WebUtils.setObjectValue(params, "keywords", StringUtils.split(keyword, " "));
        }
        PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
        Page<DictCentConsumeType> page = dictConsumeTypeService.searchScrollPage(params, pageRequest);

        return new PageTable<DictCentConsumeType>(page.getContent(), draw, page.getContent().size());
    }

    @RequestMapping(value = "/{id}/getInfo")
    public Object get(@PathVariable Long id) {
        DictCentConsumeType dictCentConsumeType = dictConsumeTypeService.getById(id);
        StatusDto result = StatusDto.buildDataSuccessStatusDto();
        result.setData(dictCentConsumeType);
        return result;
    }

    @RequestMapping(value = "/create")
    public Object create(DictCentConsumeType centConsumeType) {
        try {
            dictConsumeTypeService.insert(centConsumeType);
            return StatusDto.buildSuccessStatusDto("类型添加成功");
        } catch (Exception e) {
            logger.error("DictCentConsumeTypeRestController create error.{}", e);
            return StatusDto.buildDataFailureStatusDto(e.getMessage());
        }
    }

    @RequestMapping(value = "/update")
    public Object update(DictCentConsumeType centConsumeType) {
        try {
            dictConsumeTypeService.update(centConsumeType);
            return StatusDto.buildSuccessStatusDto("类型修改成功");
        } catch (Exception e) {
            logger.error("DictCentConsumeTypeRestController update error.{}", e);
            return StatusDto.buildDataFailureStatusDto(e.getMessage());
        }
    }

    @RequestMapping(value = "/getAll")
    public Object getAll() {
        StatusDto result = StatusDto.buildSuccessStatusDto();
        result.setData(dictConsumeTypeService.findAll());
        return result;
    }
}
