package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.service.dict.IDictPlatformService;
import com.rocoinfo.rocomall.utils.ClassToMapUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * weiys
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/platform")
public class DictPlatformRestController extends BaseController {
	@Autowired
	private IDictPlatformService platformService;

	@RequestMapping(value = "all", method = RequestMethod.GET)
	public Object all(@RequestParam(required = false) Boolean visible) {
		StatusDto result = StatusDto.buildSuccessStatusDto();

		List data = (List) ClassToMapUtil.dealSimple(platformService.findByVisibility(visible), "id", "code", "name", "visiable");
		result.setData(data);

		return result;
	}
}