package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictRankType;
import com.rocoinfo.rocomall.enumconst.Status;
import com.rocoinfo.rocomall.service.dict.IDictRankTypeService;
import com.rocoinfo.rocomall.utils.WebUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>描述:</dd>
 * <dd>公司: 大城若谷信息技术有限公司</dd>
 * <dd>创建时间：15/8/25 下午4:03</dd>
 * <dd>创建人： weiys</dd>
 * </dl>
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/rankType")
public class DictRankTypeRestController extends BaseController {

	@Autowired
	private IDictRankTypeService dictRankTypeService;

	@RequestMapping()
	public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
		@RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword, @RequestParam(required = false) Status status) {
		Map<String, Object> params = new HashMap<String, Object>();
		WebUtils.setStringValue(params, "keyword", keyword);
		WebUtils.setObjectValue(params, "status", status);
		PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<DictRankType> page = dictRankTypeService.searchScrollPage(params, pageRequest);
		return new PageTable<DictRankType>(page.getContent(), draw, Integer.valueOf(page.getTotalElements() + ""));
	}

	/**
	 * 编辑时查看
	 */
	@RequestMapping(value = "/{id}")
	public Object get(@PathVariable Long id) {
		DictRankType rankType = dictRankTypeService.getById(id);
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(rankType);
		return result;
	}

	@RequestMapping(value = "/create")
	public Object create(DictRankType rankType) {
		if (dictRankTypeService.isExistName(rankType.getName())) {
			return StatusDto.buildFailureStatusDto("排行榜类型名称已存在");
		}

		rankType.setStatus(Status.OPEN);
		dictRankTypeService.insert(rankType);
		return StatusDto.buildSuccessStatusDto("排行榜类型添加成功");
	}

	@RequestMapping(value = "/getAll")
	public Object getAll(@RequestParam(required = false) Status status) {
		StatusDto result = StatusDto.buildSuccessStatusDto();
		result.setData(dictRankTypeService.findAllWithStatus(status));
		return result;
	}

	@RequestMapping(value = "/update")
	public Object save(DictRankType rankType) {
		DictRankType oldRankType = dictRankTypeService.getById(rankType.getId());
		if (!oldRankType.getName().equalsIgnoreCase(rankType.getName()) && dictRankTypeService.isExistName(rankType.getName())) {
			return StatusDto.buildFailureStatusDto("排行榜类型名称已存在,请换个名称");
		}

		dictRankTypeService.update(rankType);
		return StatusDto.buildSuccessStatusDto("排行榜类型修改成功");
	}

	@RequestMapping(value = "/{id}/switch", method = RequestMethod.GET)
	public Object switchStatus(@PathVariable Long id, @RequestParam Status status) {
		dictRankTypeService.switchStatus(id, status);
		return StatusDto.buildDataSuccessStatusDto();
	}
}
