package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictSkuMeta;
import com.rocoinfo.rocomall.rest.admin.product.SupplierRestController;
import com.rocoinfo.rocomall.service.dict.IDictSkuMetaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/dictskumeta")
public class DictSkuMetaRestController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(SupplierRestController.class);

	@Autowired
	private IDictSkuMetaService dictSkuMetaService;

	@RequestMapping()
	public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "1") int start,
			@RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
			@RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

		Map<String, Object> params = new HashMap<String, Object>();

		PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<DictSkuMeta> page = dictSkuMetaService.searchScrollPage(params, pageRequest);

		return new PageTable<DictSkuMeta>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/{id}/getInfo")
	public Object get(@PathVariable Long id) {
		DictSkuMeta dictSkuMeta = dictSkuMetaService.getById(id);
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(dictSkuMeta);
		return result;
	}

	@RequestMapping(value = "/create")
	public Object create(DictSkuMeta dictSkuMeta) {
		dictSkuMetaService.insert(dictSkuMeta);
		return StatusDto.buildSuccessStatusDto("添加成功");
	}

	@RequestMapping(value = "/update")
	public Object update(DictSkuMeta dictSkuMeta) {
		dictSkuMetaService.update(dictSkuMeta);
		return StatusDto.buildSuccessStatusDto("修改成功");
	}

	@RequestMapping(value = "/delete/{id}")
	public Object delete(@PathVariable Long id) {
		dictSkuMetaService.deleteById(id);
		return StatusDto.buildSuccessStatusDto("删除成功");
	}

	@RequestMapping(value = "/getAll")
	public Object getAll() {
		StatusDto dto = StatusDto.buildSuccessStatusDto();
		dto.setData(dictSkuMetaService.findAll());
		return dto;
	}
}
