package com.rocoinfo.rocomall.rest.dict;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictWarehouse;
import com.rocoinfo.rocomall.rest.admin.product.SupplierRestController;
import com.rocoinfo.rocomall.service.dict.IDictWarehouseService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * @ClassName: DictStoreRestController
 * @Description: 仓库字典
 * @author Johnny(qq:147028892)
 * @date 2015年11月11日 上午11:48:15
 *
 */
@SuppressWarnings("all")
@RestController
@RequestMapping("/api/warehouse")
public class DictWarehouseRestController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(SupplierRestController.class);
	@Autowired
	private IDictWarehouseService dictWarehouseService;

	@RequestMapping()
	public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "1") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn, @RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {
		Map<String, Object> params = new HashMap<String, Object>();
		if (StringUtils.isNotBlank(keyword)) {
			params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator(keyword.trim(), " ")));
		}
		PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<DictWarehouse> page = dictWarehouseService.searchScrollPage(params, pageRequest);
		return new PageTable<DictWarehouse>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/{id}/getInfo")
	public Object get(@PathVariable Long id) {
		DictWarehouse dictWarehouse = dictWarehouseService.getById(id);
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(dictWarehouse);
		return result;
	}

	@RequestMapping(value = "/create")
	public Object create(DictWarehouse dictWarehouse) {
		try {
			dictWarehouseService.insert(dictWarehouse);
			return StatusDto.buildSuccessStatusDto("仓库字典添加成功");
		} catch (Exception e) {
			logger.error(" create error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/update")
	public Object update(DictWarehouse dictWarehouse) {
		try {
			dictWarehouseService.update(dictWarehouse);
			return StatusDto.buildSuccessStatusDto("仓库字典修改成功");
		} catch (Exception e) {
			logger.error(" create update.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	/**
	 * 获取所有仓库字典信息
	 */
	@RequestMapping(value = "/all")
	public Object findAllDictWarehouse() {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(dictWarehouseService.findAll());
		return result;
	}
}
