package com.rocoinfo.rocomall.rest.dict.express;

import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.DictProviceCity;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.service.dict.IDictProviceCityService;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;

@SuppressWarnings("all")
@RestController
@RequestMapping("/api/express")
public class DictExpressRestController extends BaseController {

	private final Logger logger = LoggerFactory.getLogger(DictExpressRestController.class);

	@Autowired
	private IDictExpressService dictExpService;
	@Autowired
	protected IDictProviceCityService provCityService;

	@RequestMapping()
	public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "1") int start, @RequestParam(defaultValue = "20") int length, @RequestParam(defaultValue = "id") String orderColumn,
		@RequestParam(defaultValue = "DESC") String orderSort, @RequestParam(required = false) String keyword) {

		Map<String, Object> params = new HashMap<String, Object>();
		if (StringUtils.isNotBlank(keyword)) {
			params.put("keyword", Arrays.asList(StringUtils.splitByWholeSeparator(keyword.trim(), " ")));
		}
		PageRequest pageRequest = new PageRequest(start, length, new Sort(Sort.Direction.valueOf(orderSort.toUpperCase()), orderColumn));
		Page<DictExpress> page = dictExpService.searchScrollPage(params, pageRequest);

		return new PageTable<DictExpress>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/{id}/getInfo")
	public Object get(@PathVariable Long id) {
		DictExpress dictExpress = dictExpService.getById(id);

		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(dictExpress);

		return result;
	}

	@RequestMapping(value = "/create")
	public Object create(DictExpress express) {
		try {
			dictExpService.insert(express);
			return StatusDto.buildSuccessStatusDto("快递公司添加成功");
		} catch (Exception e) {
			logger.error(" create error.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/update")
	public Object update(DictExpress express) {
		try {
			dictExpService.update(express);
			return StatusDto.buildSuccessStatusDto("快递公司修改成功");
		} catch (Exception e) {
			logger.error(" create update.{}", e);
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	/**
	 * 获取快递公司绑定的所有城市
	 * 
	 * @param id 快递公司ID
	 * @return 2015年11月23日 下午5:47:41
	 */
	@RequestMapping(value = "/findcitys/{id}")
	public Object findCitys(@PathVariable Long id) {
		try {
			List<DictProviceCity> citys = dictExpService.findAllCityById(id);
			StatusDto result = StatusDto.buildDataSuccessStatusDto();
			result.setData(citys);
			return result;
		} catch (Exception e) {
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	/**
	 * 绑定城市和快递公司
	 * 
	 * @param id
	 * @param citys
	 * @return 2015年11月23日 下午6:43:40
	 */
	@RequestMapping(value = "/updatecitys")
	public Object findCitys(@RequestParam Long id, @RequestParam(required = false) List<Long> citys) {
		if (id == null)
			return StatusDto.buildDataFailureStatusDto("快递公司id为空！");
		//验证所选城市是否被其他快递绑定过
		if (CollectionUtils.isNotEmpty(citys)) {
			List<DictProviceCity> expCityList = dictExpService.findCityExpressByBoundedCityIds(citys);
			if (CollectionUtils.isNotEmpty(expCityList)) {
				StringBuilder errorBuf = new StringBuilder();
				for (DictProviceCity city : expCityList) {
					if (!city.getExpress().getId().equals(id)) {
						errorBuf.append("[" + city.getName() + " 已绑定  " + city.getExpress().getName() + "]").append(",");
					}
				}

				if (errorBuf.length() > 0) {
					return StatusDto.buildDataFailureStatusDto(errorBuf.toString());
				}
			}
		}
		//绑定快递公司
		try {
			DictExpress express = new DictExpress();
			List<DictProviceCity> cityList = new ArrayList<DictProviceCity>();
			if (citys != null) {
				for (Long ids : citys) {
					DictProviceCity dictProviceCity = new DictProviceCity();
					dictProviceCity.setId(ids);
					cityList.add(dictProviceCity);
				}
			}
			express.setId(id);
			express.setCitys(cityList);
			dictExpService.updateCitys(express);
			return StatusDto.buildDataSuccessStatusDto();
		} catch (Exception e) {
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/gotocitys")
	public Object buildProvCity(@RequestParam Long id) {
		List<Long> boundCityIds = dictExpService.findBoundedCityIdsById(id);
		return provCityService.buildProvCityNodes(boundCityIds);
	}

	/**
	 * 获取所有物流信息
	 */
	@RequestMapping(value = "/all")
	public Object findAllExpress() {
		StatusDto result = StatusDto.buildDataSuccessStatusDto();
		result.setData(dictExpService.findAll());
		return result;
	}
}