package com.rocoinfo.rocomall.rest.dict.express;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rocoinfo.rocomall.common.BaseController;
import com.rocoinfo.rocomall.dto.PageTable;
import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.entity.dict.express.DictExpress;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeItem;
import com.rocoinfo.rocomall.entity.dict.express.ExpressFeeTemplate;
import com.rocoinfo.rocomall.entity.dict.express.FeeItemCity;
import com.rocoinfo.rocomall.service.dict.express.IDictExpressService;
import com.rocoinfo.rocomall.service.dict.express.IExpressFeeTemplateService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.*;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

@RestController
@RequestMapping("/api/expressTemplate")
public class ExpressTemplateRestController extends BaseController {
	@Autowired
	private IDictExpressService dictExpService;
	@Autowired
	private IExpressFeeTemplateService expressTemplateService;

	@RequestMapping()
	public Object list(@RequestParam(required = false) String draw, @RequestParam(defaultValue = "0") int start, @RequestParam(defaultValue = "20") int length) {
		PageRequest pageRequest = new PageRequest(start, length);
		Map<String, Object> params = Maps.newHashMap();
		Page<ExpressFeeTemplate> page = expressTemplateService.searchScrollPage(params, pageRequest);
		buildDictExpress(page.getContent());
		return new PageTable<ExpressFeeTemplate>(page.getContent(), draw, page.getContent().size());
	}

	@RequestMapping(value = "/create", method = RequestMethod.POST)
	public Object create(ExpressFeeTemplate feeTemplate) {
		try {
			if (expressTemplateService.countTemplateByExpress(feeTemplate) > 0) {
				return StatusDto.buildFailureStatusDto("该快递公司已创建模板,请换个快递公司");
			}

			pretreatTemplate(feeTemplate);

			expressTemplateService.insert(feeTemplate);
			return StatusDto.buildSuccessStatusDto("模板创建成功");
		} catch (Exception e) {
			return StatusDto.buildFailureStatusDto(e.getMessage());
		}
	}

	@RequestMapping(value = "/update", method = RequestMethod.POST)
	public Object update(ExpressFeeTemplate feeTemplate) {
		try {
			if (expressTemplateService.countTemplateByExpress(feeTemplate) > 0) {
				return StatusDto.buildFailureStatusDto("该快递公司已创建模板,请换个快递公司");
			}
			pretreatTemplate(feeTemplate);
			expressTemplateService.update(feeTemplate);
			return StatusDto.buildSuccessStatusDto("快递模板修改成功");
		} catch (Exception e) {
			return StatusDto.buildFailureStatusDto(e.getMessage());
		}
	}

	/**
	 * 复制模板
	 */
	@RequestMapping(value = "/{id}/clone")
	public Object cloneTemplate(@PathVariable Long id) {
		try {
			expressTemplateService.cloneTemplate(id);
			return StatusDto.buildSuccessStatusDto("模板复制成功！");
		} catch (Exception e) {
			return StatusDto.buildDataFailureStatusDto(e.getMessage());
		}
	}

	private void buildDictExpress(List<ExpressFeeTemplate> feeTemplateList) {
		if (CollectionUtils.isNotEmpty(feeTemplateList)) {
			Map<Long, DictExpress> expressMap = dictExpService.findAllExpressMap();
			for (ExpressFeeTemplate feeTemplate : feeTemplateList) {
				//复制过来的模板没有快递公司,会报空指针
				try {
					feeTemplate.setExpress(expressMap.get(feeTemplate.getExpress().getId()));
				} catch (Exception e) {
					//页面需要快递公司的name属性，不能为空
					DictExpress exp = new DictExpress();
					exp.setName("");
					feeTemplate.setExpress(exp);
				}
			}
		}
	}

	private void pretreatTemplate(ExpressFeeTemplate feeTemplate) {
		if (CollectionUtils.isNotEmpty(feeTemplate.getItems())) {
			Iterator<ExpressFeeItem> itemIter = feeTemplate.getItems().iterator();
			while (itemIter.hasNext()) {
				ExpressFeeItem item = itemIter.next();
				if (item.getQamt() == null) {
					itemIter.remove();
				} else {
					item.setItemCitys(convertToCityItemList(item.getCityIds()));
				}
			}
		}
	}

	private List<FeeItemCity> convertToCityItemList(String cityIds) {
		List<FeeItemCity> cityList = null;
		if (StringUtils.isNotBlank(cityIds)) {
			cityList = Lists.newArrayList();
			String[] cityIdArray = StringUtils.split(cityIds, ",");
			for (String cityId : cityIdArray) {
				FeeItemCity item = new FeeItemCity();
				item.setCityId(NumberUtils.toLong(cityId));
				cityList.add(item);
			}
		}
		return cityList;
	}

}