package com.rocoinfo.rocomall.service;

import com.rocoinfo.rocomall.dto.StatusDto;
import com.rocoinfo.rocomall.enumconst.UserType;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import com.rocoinfo.rocomall.repository.account.AdminUserDao;
import com.rocoinfo.rocomall.repository.account.RoleDao;
import com.rocoinfo.rocomall.service.impl.LoginLogService;
import com.rocoinfo.rocomall.shiro.token.MyUsernamePasswordToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 用户登录Service
 *
 * @author liuwei
 * @author Aaron
 */
@SuppressWarnings("all")
@Service
public class LoginService {

    @Autowired
    private LogoutService logoutService;
    @Autowired
    private JedisTemplate jedisTemplate;
    @Autowired
    private AdminUserDao userDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private LoginLogService loginLogService;

    private final Logger logger = LoggerFactory.getLogger(LoginService.class);

    /**
     * @return 登录成功返回User对象，登录失败返回状态码为400的ResponseEntity对象
     */
    public Object login(String loginName, String password, boolean rememberMe, UserType userType) {
        try {
            login(new MyUsernamePasswordToken(loginName, password, rememberMe, userType));
            return StatusDto.buildSuccessStatusDto();
        } catch (AuthenticationException e) {
            return StatusDto.buildDataFailureStatusDto(getErrorResponseEntity(e));
        }
    }

    public void login(AuthenticationToken token) throws AuthenticationException {
        Subject subject = SecurityUtils.getSubject();
        //如果已登录，先退出
        if (subject.getPrincipal() != null) {
            logoutService.logout();
        }
        //登录
        subject.login(token);
    }

    private String getErrorResponseEntity(AuthenticationException e) {
        final String loginFail = "账户或密码不正确";

        if (e instanceof IncorrectCredentialsException) {
            return "账户或密码不正确";
        }
        if (e instanceof ExpiredCredentialsException) {
            return "密码已过期";
        }
        if (e instanceof CredentialsException) {
            return "密码验证失败";
        }
        if (e instanceof UnknownAccountException) {
            return "账户或密码不正确";
        }
        if (e instanceof LockedAccountException) {
            return "用户已被锁定";
        }
        if (e instanceof DisabledAccountException) {
            return "用户已被禁用";
        }
        if (e instanceof ExcessiveAttemptsException) {
            return "尝试次数太多";
        }
        if (e instanceof AccountException) {
            String error = e.getMessage();
            if (StringUtils.isBlank(error)) {
                error = loginFail;
            }
            return error;
        }

        logger.debug(loginFail, e);
        return loginFail;
    }
}
