package com.rocoinfo.rocomall.shiro;

import com.rocoinfo.rocomall.utils.PasswordUtil;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.springframework.beans.factory.FactoryBean;

/**
 * custom validate password
 * 
 * @author michael
 */
public class CustomShiroCredentialsMatherFactoryBean implements FactoryBean<HashedCredentialsMatcher> {

	@Override
	public HashedCredentialsMatcher getObject() throws Exception {
		//设定Password校验的Hash算法与迭代次数.
		HashedCredentialsMatcher matcher = new HashedCredentialsMatcher(PasswordUtil.HASH_ALGORITHM);
		matcher.setHashIterations(PasswordUtil.HASH_ITERATIONS);
		return matcher;
	}

	@Override
	public Class<?> getObjectType() {
		return HashedCredentialsMatcher.class;
	}

	@Override
	public boolean isSingleton() {
		return true;
	}
}
