package com.rocoinfo.rocomall.shiro;

import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.Role;
import com.rocoinfo.rocomall.service.impl.AdminUserService;
import com.rocoinfo.rocomall.service.impl.UserService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springside.modules.utils.Collections3;

import java.util.LinkedHashSet;
import java.util.List;

/**
 * @author zhangmin
 */
public abstract class ShiroAbstractRealm extends AuthorizingRealm {

    protected AdminUserService adminService;

    protected UserService userService;

    private Logger logger = LoggerFactory.getLogger(ShiroAbstractRealm.class);

    /**
     * 授权查询回调函数, 进行鉴权但缓存中无用户的授权信息时调用.
     */
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        try {
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            ShiroUser shiroUser = (ShiroUser) principals.getPrimaryPrincipal();
            AdminUser adminUsr = adminService.getById(shiroUser.getId());
            if (adminUsr != null) {
                adminService.buildAdminPermissionDetail(adminUsr);
                info.addRoles(getRoleNames(adminUsr));
                info.addStringPermissions(getPermissions(adminUsr));
            }
            return info;
        } catch (RuntimeException e) {
            logger.warn("授权时发生异常", e);
            throw e;
        }
    }

    @SuppressWarnings("unchecked")
    private List<String> getRoleNames(AdminUser adminUsr) {
        return Collections3.extractToList(adminUsr.getRoles(), "name");
    }

    private LinkedHashSet<String> getPermissions(AdminUser adminUsr) {
        LinkedHashSet<String> permissions = new LinkedHashSet<String>();
        if (CollectionUtils.isNotEmpty(adminUsr.getRoles())) {
            for (Role role : adminUsr.getRoles()) {
                permissions.addAll(role.getPermissions());
            }
        }
        return permissions;
    }

    public void setAdminService(AdminUserService adminService) {
        this.adminService = adminService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

}
