/*******************************************************************************
 * Copyright (c) 2005, 2014 springside.github.io
 * <p/>
 * Licensed under the Apache License, Version 2.0 (the "License");
 *******************************************************************************/
package com.rocoinfo.rocomall.shiro;


import com.rocoinfo.rocomall.entity.account.AdminUser;
import com.rocoinfo.rocomall.entity.account.User;
import com.rocoinfo.rocomall.enumconst.SwitchStatus;
import com.rocoinfo.rocomall.enumconst.UserType;
import com.rocoinfo.rocomall.shiro.token.MyUsernamePasswordToken;
import org.apache.shiro.authc.*;
import org.apache.shiro.util.ByteSource;
import org.springside.modules.utils.Encodes;

public class ShiroDbRealm extends ShiroAbstractRealm {

    /**
     * 认证回调函数,登录时调用.
     */
    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        MyUsernamePasswordToken token = (MyUsernamePasswordToken) authcToken;
        Object user = null;
        // 根据前后台用户类型 走不同的查询方法
        if (UserType.ADMIN.equals(token.getUserType())) {
            user = this.adminService.getAdminByUsername(token.getUsername());
        }

        if (UserType.MEMBER.equals(token.getUserType())) {
            user = this.userService.getByUsername(token.getUsername());
        }

        if (user == null) {
            throw new AccountException("不存在用户：" + token.getUsername());
        }

        try {
            ShiroUser shiroUser = null;
            String password = null;
            byte[] salt = null;

            // 后台管理员登录
            if (user instanceof AdminUser) {
                AdminUser adminUser = (AdminUser) user;
                if (adminUser.getStatus().equals(SwitchStatus.LOCK))
                    throw new LockedAccountException();
                shiroUser = new ShiroUser(adminUser.getId(), adminUser.getUsername(), adminUser.getName());
                password = adminUser.getPassword();
                salt = Encodes.decodeHex(adminUser.getSalt());
            }

            // 前台用户登录
            if (user instanceof User) {
                User member = (User) user;
                if (member.getStatus().equals(SwitchStatus.LOCK))
                    throw new LockedAccountException();
                shiroUser = new ShiroUser(member.getId(), member.getUsername(), member.getName());
                password = member.getPassword();
                salt = Encodes.decodeHex(member.getSalt());
            }

            return new SimpleAuthenticationInfo(shiroUser, password, ByteSource.Util.bytes(salt), getName());
        } catch (RuntimeException e) {
            throw e;
        }

    }

}
