package com.rocoinfo.rocomall.shiro.listener;

import com.rocoinfo.rocomall.shiro.session.ShiroSessionService;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomSessionListener implements SessionListener {

	private static final Logger logger = LoggerFactory.getLogger(CustomSessionListener.class);

	@Autowired
	private ShiroSessionService sessionService;

	@Override
	public void onStart(Session session) {
	}

	//会话被停止时触发  
	@Override
	public void onStop(Session session) {
		sessionService.deleteSession(session);
		logger.debug("CustomSessionListener session {} 被销毁", session.getId());
	}

	//会话过期时触发  
	@Override
	public void onExpiration(Session session) {
		sessionService.deleteSession(session);
		logger.debug("CustomSessionListener session {} 过期", session.getId());
	}
}
