package com.rocoinfo.rocomall.shiro.session;

import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.Serializable;
import java.util.Collection;

/**
 * custom shiro sessionDAO
 * 
 * @author michael
 */
public class CustomShiroSessionDAO extends AbstractSessionDAO {

	private ShiroSessionRepository shiroSessionRepository;

	private Logger logger = LoggerFactory.getLogger(CustomShiroSessionDAO.class);

	//更新会话；如更新会话最后访问时间/停止会话/设置超时时间/设置移除属性等会调用  
	@Override
	public void update(Session session) throws UnknownSessionException {
		logger.debug("update session {}", session.getId());
		getShiroSessionRepository().saveSession(session);
	}

	//删除会话；当会话过期/会话停止（如用户退出时）会调用  
	@Override
	public void delete(Session session) {
		if (session == null) {
			return;
		}
		Serializable id = session.getId();
		if (id != null) {
			logger.debug("delete session {}", id);
			getShiroSessionRepository().deleteSession(id);
		}
	}

	@Override
	public Collection<Session> getActiveSessions() {
		logger.debug("get active sessions");
		return getShiroSessionRepository().getAllSessions();
	}

	@Override
	protected Serializable doCreate(Session session) {
		logger.debug("do create session");
		Serializable sessionId = this.generateSessionId(session);
		this.assignSessionId(session, sessionId);
		getShiroSessionRepository().saveSession(session);
		return sessionId;
	}

	@Override
	protected Session doReadSession(Serializable sessionId) {
		logger.debug("do read session {}", sessionId);
		return getShiroSessionRepository().getSession(sessionId);
	}

	public ShiroSessionRepository getShiroSessionRepository() {
		return shiroSessionRepository;
	}

	public void setShiroSessionRepository(ShiroSessionRepository shiroSessionRepository) {
		this.shiroSessionRepository = shiroSessionRepository;
	}

}
