package com.rocoinfo.rocomall.shiro.session;

import com.google.common.collect.Lists;
import com.rocoinfo.rocomall.redis.JedisTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import redis.clients.jedis.JedisPubSub;

import java.util.List;
import java.util.Map;

/**
 * Redis消息统一处理类
 */
public class PubSubHandle extends JedisPubSub {

	protected static Logger logger = LoggerFactory.getLogger(PubSubHandle.class);

	private Map<String, PubSubService> channelHandles;
	@Autowired
	private JedisTemplate jedisTemplate;

	public void subscribe() {
		new Thread(new Runnable() {
			@Override
			public void run() {
				List<String> channelList = Lists.newArrayList();
				channelList.addAll(channelHandles.keySet());
				try {
					jedisTemplate.subscribe(PubSubHandle.this, channelList.toArray(new String[]{}));
				} catch (Exception e) {
					logger.warn("Redis消息订阅失败", e);
				}
			}
		}).start();
	}

	// 取得订阅的消息后分发
	public void onMessage(String channel, String message) {
		try {
			logger.info("从消息通道{}得到消息:{} : ", channel, message);
			for (String key : channelHandles.keySet()) {
				if (channel.equals(key)) {
					channelHandles.get(key).handle(channel, message);
				}
			}
		} catch (Exception e) {
			logger.warn("处理来自通道 {} 的消息 {} 出现异常", channel, message, e);
		}

	}

	// 初始化订阅时候的处理  
	public void onSubscribe(String channel, int subscribedChannels) {
		logger.info("初始化订阅Redis消息通道 : {} = {}", channel, subscribedChannels);
	}

	/**
	 * 取消订阅某个通道时回调
	 * 
	 * @param subscribedChannels 取消订阅后，客户端还剩余订阅的通道个数
	 */
	public void onUnsubscribe(String channel, int subscribedChannels) {
		logger.info("取消订阅Redis消息通道 : {} = {}", channel, subscribedChannels);
	}

	public void setChannelHandles(Map<String, PubSubService> channelHandles) {
		this.channelHandles = channelHandles;
	}

	@Override
	public void onPMessage(String pattern, String channel, String message) {

	}

	@Override
	public void onPUnsubscribe(String pattern, int subscribedChannels) {

	}

	@Override
	public void onPSubscribe(String pattern, int subscribedChannels) {

	}
}
