package com.rocoinfo.rocomall.shiro.session;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ShiroSessionUncacheService implements PubSubService {

	private static final Logger logger = LoggerFactory.getLogger(ShiroSessionUncacheService.class);

	@Autowired
	private CachingShiroSessionDao sessionDao;

	@Override
	public void handle(String channel, String message) {
		logger.debug("channel {} , message {} ", channel, message);
		sessionDao.uncache(message);
	}
}
